package ru.yandex.direct.api.v5.entity.adgroups;

import java.util.List;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.api.v5.validation.DefectTypes;
import ru.yandex.direct.core.entity.adgroup.service.validation.AdGroupDefectTranslations;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.types.Identity;
import ru.yandex.direct.queryrec.model.Language;

import static ru.yandex.direct.core.entity.region.RegionConstants.LANGUAGE_TO_ALLOWED_REGIONS_CONTAINER;

public class AdGroupDefectTypes {
    private AdGroupDefectTypes() {
    }

    public static DefectType archivedAdGroupModification() {
        return DefectTypes.badStatus()
                .withDetailedMessage(adGroupTranslations().cantEditArchivedAdGroup());
    }

    public static DefectType inconsistentGeoWithBannerLanguages(Language language, Long bannerId) {
        return new DefectType(
                6100,
                adGroupTranslations().invalidGeoTargeting(),
                LANGUAGE_TO_ALLOWED_REGIONS_CONTAINER.get(language).getAdGroupDefectMessage(new Identity(bannerId)));
    }

    private static AdGroupDefectTranslations adGroupTranslations() {
        return AdGroupDefectTranslations.INSTANCE;
    }

    private static CommonDefectTranslations commonTranslations() {
        return CommonDefectTranslations.INSTANCE;
    }

    public static DefectType inconsistentAdGroupTypeToCampaign() {
        return DefectTypes.inconsistentState()
                .withDetailedMessage(adGroupTranslations().inconsistentAdGroupTypeToCampaign());
    }

    public static DefectType campaignAdGroupsLimitReached(int max) {
        return DefectTypes.maxElementsExceeded(max)
                .withDetailedMessage(adGroupTranslations().campaignAdGroupsLimitReached(Identity.of((long) max)));
    }

    public static DefectType adGroupNameIsNotSet() {
        return DefectTypes.requiredButEmpty()
                .withDetailedMessage(adGroupTranslations().adGroupNameIsNotSet());
    }

    public static DefectType adGroupNameCantBeEmpty() {
        return DefectTypes.invalidFormat()
                .withDetailedMessage(adGroupTranslations().adGroupNameCantBeEmpty());
    }

    public static DefectType adGroupNameTooLong(int maxLength) {
        return DefectTypes.maxStringSize(maxLength)
                .withDetailedMessage(adGroupTranslations().adGroupNameTooLong(new Identity(maxLength)));
    }

    public static DefectType advertisedAppLinkIsNotSet() {
        return DefectTypes.requiredButEmpty()
                .withDetailedMessage(adGroupTranslations().advertisedAppLinkIsNotSetDetailed());
    }

    public static DefectType feedNotExist(Long feedId) {
        return DefectTypes.notFound()
                .withDetailedMessage(adGroupTranslations().feedNotExistDetailed(new Identity(feedId)));
    }

    public static DefectType feedsNotAllowed() {
        return DefectTypes.parameterWillNotBeApplied()
                .withDetailedMessage(adGroupTranslations().feedsNotAllowed());
    }

    public static DefectType invalidAppLinkFormat() {
        return DefectTypes.invalidFormat()
                .withDetailedMessage(adGroupTranslations().invalidAppLinkFormatDetailed());
    }

    public static DefectType appStoreIsNotSupported(List<String> supportedAppStores) {
        return DefectTypes.unsupportedAppStore()
                .withDetailedMessage(adGroupTranslations().unsupportedAppStoreDetailed(
                        String.join(", ", supportedAppStores)));
    }

    public static DefectType invalidAppStoreUrl() {
        return DefectTypes.invalidFormat()
                .withDetailedMessage(adGroupTranslations().invalidAppStoreUrlDetailed());
    }

    public static DefectType minOsVersionIsNotSet() {
        return DefectTypes.requiredButEmpty()
                .withDetailedMessage(adGroupTranslations().minOsVersionIsNotSetDetailed());
    }

    public static DefectType invalidMinOsVersion() {
        return DefectTypes.invalidFormat()
                .withDetailedMessage(adGroupTranslations().invalidMinOsVersionDetailed());
    }

    public static DefectType deviceTargetingIsNotSet() {
        return DefectTypes.requiredButEmpty()
                .withDetailedMessage(adGroupTranslations().deviceTargetingIsNotSetDetailed());
    }

    public static DefectType networkTargetingIsNotSet() {
        return DefectTypes.requiredButEmpty()
                .withDetailedMessage(adGroupTranslations().networkTargetingIsNotSetDetailed());
    }

    public static DefectType dynamicTextDomainIsNotSet() {
        return DefectTypes.requiredButEmpty()
                .withDetailedMessage(adGroupTranslations().dynamicTextDomainIsNotSet());
    }

    public static DefectType invalidDynamicTextDomain() {
        return DefectTypes.invalidFormat()
                .withDetailedMessage(adGroupTranslations().invalidDynamicTextDomainDetailed());
    }

    public static DefectType notFound() {
        return DefectTypes.notFound()
                .withDetailedMessage(adGroupTranslations().notFoundDetailed());
    }

    public static DefectType unableToDelete() {
        return DefectTypes.unableToDelete()
                .withDetailedMessage(adGroupTranslations().unableToDeleteDetailed());
    }

    public static DefectType adGroupTypeNotSupported() {
        return DefectTypes.notSupported()
                .withDetailedMessage(commonTranslations().adGroupTypeNotSupportedDetailed());
    }

    private static DefectType maxAdGroupsPerRequest() {
        return new DefectType(9300, commonTranslations().maxElementsPerRequestShort());
    }

    public static DefectType maxAdGroupsPerAddRequest(int max) {
        return maxAdGroupsPerRequest()
                .withDetailedMessage((path, value) -> adGroupTranslations()
                        .maxAdGroupsPerRequestDetailed(new Identity(max)));
    }

    public static DefectType maxAdGroupsPerUpdateRequest(int max) {
        return maxAdGroupsPerRequest()
                .withDetailedMessage((path, value) -> adGroupTranslations()
                        .maxAdGroupsPerUpdateRequestDetailed(new Identity(max)));
    }

    public static DefectType duplicatedObject() {
        return DefectTypes.duplicatedObject()
                .withDetailedMessage((Translatable) null);
    }

    public static DefectType inconsistentAdGroupType() {
        return DefectTypes.badParams()
                .withDetailedMessage(adGroupTranslations().inconsistentAdGroupType());

    }

    public static DefectType inconsistentDynamicAdGroupSubType() {
        return DefectTypes.inconsistentState()
                .withDetailedMessage(adGroupTranslations().inconsistentDynamicAdGroupSubType());

    }

    public static DefectType restrictedRegions() {
        return new DefectType(
                10172,
                adGroupTranslations().restrictedRegionsShort(),
                adGroupTranslations().restrictedRegionsDetails());
    }

    public static DefectType contentPromotionSeveralTypesNotAllowed() {
        return DefectTypes.invalidValue().withDetailedMessage(
                adGroupTranslations().contentPromotionSeveralTypesNotAllowed());
    }


    public static DefectType contentPromotionDistinctTypeFromExisting() {
        return DefectTypes.invalidValue().withDetailedMessage(
                adGroupTranslations().contentPromotionDistinctTypeFromExisting());
    }

    public static DefectType contentPromotionAdGroupTypeChanged() {
        return DefectTypes.invalidValue().withDetailedMessage(
                adGroupTranslations().contentPromotionAdGroupTypeChanged());
    }

    public static DefectType storeUrlMustBeTheSameForAllGroupsInMobileContentCampaign() {
        return DefectTypes.inconsistentState()
                .withDetailedMessage(adGroupTranslations().storeUrlMustBeTheSameForAllGroupsInMobileContentCampaign());
    }

    public static DefectType storeUrlMustBeTheSameAsUrlInMobileContentCampaign() {
        return DefectTypes.inconsistentState()
                .withDetailedMessage(adGroupTranslations().storeUrlMustBeTheSameAsUrlInMobileContentCampaign());
    }

    public static DefectType minusKeywordsNotAllowed() {
        return DefectTypes.inconsistentState().withDetailedMessage(adGroupTranslations().minusKeywordsAreNotAllowed());
    }

    public static DefectType hyperGeoSettingsWasFlushed() {
        return new DefectType(10180, adGroupTranslations().hyperGeoSettingsWasFlushed());
    }

    public static DefectType logoIsOnlyForBannersWithoutCreative() {
        return DefectTypes.badParams().withDetailedMessage(adGroupTranslations().logoIsOnlyForBannersWithoutCreative());
    }
}
