package ru.yandex.direct.api.v5.entity.adgroups.container

import ru.yandex.direct.api.v5.validation.DefectType
import ru.yandex.direct.core.entity.adgroup.container.ComplexPerformanceAdGroup
import ru.yandex.direct.core.entity.adgroup.model.AdGroup
import ru.yandex.direct.model.ModelChanges

abstract class AdGroupsContainer

/** Для передачи информации об ошибках с первого (externalRequest) на второй (internalRequest) этап валидации. */
data class AdGroupsValidationSignalContainer(
    val defectType: DefectType
) : AdGroupsContainer()

data class AddAdGroupsSimpleContainer(
    val adGroup: AdGroup
) : AdGroupsContainer()

data class AddAdGroupsComplexPerformanceContainer(
    val complexAdGroup: ComplexPerformanceAdGroup
) : AdGroupsContainer()

data class UpdateAdGroupsSimpleContainer(
    val modelChanges: ModelChanges<out AdGroup>,

    val oldAdGroup: AdGroup?
) : AdGroupsContainer()

data class UpdateAdGroupsComplexPerformanceContainer(
    val complexAdGroup: ComplexPerformanceAdGroup,

    val oldAdGroup: AdGroup?
) : AdGroupsContainer()
