package ru.yandex.direct.api.v5.entity.adgroups.delegate;

import java.util.Arrays;
import java.util.function.Predicate;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.adgroups.AdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.ContentPromotionAdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.DynamicTextAdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.DynamicTextFeedAdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.MobileAppAdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.SmartAdGroupFieldEnum;
import com.yandex.direct.api.v5.adgroups.TextAdGroupFeedParamsFieldEnum;

@ParametersAreNonnullByDefault
public enum AdGroupAnyFieldEnum {
    AD_GROUP_ID(AdGroupFieldEnum.class, AdGroupFieldEnum.ID),
    AD_GROUP_CAMPAIGN_ID(AdGroupFieldEnum.class, AdGroupFieldEnum.CAMPAIGN_ID),
    AD_GROUP_STATUS(AdGroupFieldEnum.class, AdGroupFieldEnum.STATUS),
    AD_GROUP_NAME(AdGroupFieldEnum.class, AdGroupFieldEnum.NAME),
    AD_GROUP_REGION_IDS(AdGroupFieldEnum.class, AdGroupFieldEnum.REGION_IDS),
    AD_GROUP_RESTRICTED_REGION_IDS(AdGroupFieldEnum.class, AdGroupFieldEnum.RESTRICTED_REGION_IDS),
    AD_GROUP_NEGATIVE_KEYWORDS(AdGroupFieldEnum.class, AdGroupFieldEnum.NEGATIVE_KEYWORDS),
    AD_GROUP_NEGATIVE_KEYWORD_SHARED_SET_IDS(AdGroupFieldEnum.class, AdGroupFieldEnum.NEGATIVE_KEYWORD_SHARED_SET_IDS),
    AD_GROUP_TYPE(AdGroupFieldEnum.class, AdGroupFieldEnum.TYPE),
    AD_GROUP_TRACKING_PARAMS(AdGroupFieldEnum.class, AdGroupFieldEnum.TRACKING_PARAMS),
    AD_GROUP_SUBTYPE(AdGroupFieldEnum.class, AdGroupFieldEnum.SUBTYPE),
    AD_GROUP_SERVING_STATUS(AdGroupFieldEnum.class, AdGroupFieldEnum.SERVING_STATUS),
    MOBILE_APP_AD_GROUP_STORE_URL(MobileAppAdGroupFieldEnum.class, MobileAppAdGroupFieldEnum.STORE_URL),
    MOBILE_APP_AD_GROUP_TARGET_DEVICE_TYPE(MobileAppAdGroupFieldEnum.class,
            MobileAppAdGroupFieldEnum.TARGET_DEVICE_TYPE),
    MOBILE_APP_AD_GROUP_TARGET_CARRIER(MobileAppAdGroupFieldEnum.class, MobileAppAdGroupFieldEnum.TARGET_CARRIER),
    MOBILE_APP_AD_GROUP_TARGET_OPERATING_SYSTEM_VERSION(MobileAppAdGroupFieldEnum.class,
            MobileAppAdGroupFieldEnum.TARGET_OPERATING_SYSTEM_VERSION),
    MOBILE_APP_AD_GROUP_APP_ICON_MODERATION(MobileAppAdGroupFieldEnum.class,
            MobileAppAdGroupFieldEnum.APP_ICON_MODERATION),
    MOBILE_APP_AD_GROUP_APP_AVAILABILITY_STATUS(MobileAppAdGroupFieldEnum.class,
            MobileAppAdGroupFieldEnum.APP_AVAILABILITY_STATUS),
    MOBILE_APP_AD_GROUP_APP_OPERATING_SYSTEM_TYPE(MobileAppAdGroupFieldEnum.class,
            MobileAppAdGroupFieldEnum.APP_OPERATING_SYSTEM_TYPE),
    DYNAMIC_TEXT_AD_GROUP_AUTOTARGETING_CATEGORIES(DynamicTextAdGroupFieldEnum.class,
            DynamicTextAdGroupFieldEnum.AUTOTARGETING_CATEGORIES),
    DYNAMIC_TEXT_AD_GROUP_DOMAIN_URL(DynamicTextAdGroupFieldEnum.class, DynamicTextAdGroupFieldEnum.DOMAIN_URL),
    DYNAMIC_TEXT_AD_GROUP_DOMAIN_URL_PROCESSING_STATUS(DynamicTextAdGroupFieldEnum.class,
            DynamicTextAdGroupFieldEnum.DOMAIN_URL_PROCESSING_STATUS),
    DYNAMIC_TEXT_FEED_AD_GROUP_AUTOTARGETING_CATEGORIES(DynamicTextFeedAdGroupFieldEnum.class,
            DynamicTextFeedAdGroupFieldEnum.AUTOTARGETING_CATEGORIES),
    DYNAMIC_TEXT_FEED_AD_GROUP_SOURCE(DynamicTextFeedAdGroupFieldEnum.class, DynamicTextFeedAdGroupFieldEnum.SOURCE),
    DYNAMIC_TEXT_FEED_AD_GROUP_FEED_ID(DynamicTextFeedAdGroupFieldEnum.class, DynamicTextFeedAdGroupFieldEnum.FEED_ID),
    DYNAMIC_TEXT_FEED_AD_GROUP_SOURCE_TYPE(DynamicTextFeedAdGroupFieldEnum.class,
            DynamicTextFeedAdGroupFieldEnum.SOURCE_TYPE),
    DYNAMIC_TEXT_FEED_AD_GROUP_SOURCE_PROCESSING_STATUS(DynamicTextFeedAdGroupFieldEnum.class,
            DynamicTextFeedAdGroupFieldEnum.SOURCE_PROCESSING_STATUS),
    SMART_AD_GROUP_FEED_ID(SmartAdGroupFieldEnum.class, SmartAdGroupFieldEnum.FEED_ID),
    SMART_AD_GROUP_AD_TITLE_SOURCE(SmartAdGroupFieldEnum.class, SmartAdGroupFieldEnum.AD_TITLE_SOURCE),
    SMART_AD_GROUP_AD_BODY_SOURCE(SmartAdGroupFieldEnum.class, SmartAdGroupFieldEnum.AD_BODY_SOURCE),
    SMART_AD_GROUP_LOGO_EXTENSION_HASH(SmartAdGroupFieldEnum.class, SmartAdGroupFieldEnum.LOGO_EXTENSION_HASH),
    SMART_AD_GROUP_LOGO_EXTENSION_MODERATION(SmartAdGroupFieldEnum.class,
            SmartAdGroupFieldEnum.LOGO_EXTENSION_MODERATION),
    ADGROUP_CONTENT_PROMOTION_TYPE(ContentPromotionAdGroupFieldEnum.class,
            ContentPromotionAdGroupFieldEnum.PROMOTED_CONTENT_TYPE),
    TEXT_AD_GROUP_FEED_ID(TextAdGroupFeedParamsFieldEnum.class, TextAdGroupFeedParamsFieldEnum.FEED_ID),
    TEXT_AD_GROUP_FEED_CATEGORY_IDS(TextAdGroupFeedParamsFieldEnum.class,
            TextAdGroupFeedParamsFieldEnum.FEED_CATEGORY_IDS);

    private final Class<?> enumClass;
    private final Enum value;

    AdGroupAnyFieldEnum(Class<?> enumClass, Enum value) {
        this.enumClass = enumClass;
        this.value = value;
    }

    public static AdGroupAnyFieldEnum fromAdGroupFieldEnum(AdGroupFieldEnum adGroupFieldEnum) {
        return Arrays.stream(AdGroupAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(AdGroupFieldEnum.class) && v.getValue().equals(adGroupFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static AdGroupAnyFieldEnum fromMobileAppAdGroupFieldEnum(
            MobileAppAdGroupFieldEnum mobileAppAdGroupFieldEnum) {
        return Arrays.stream(AdGroupAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(MobileAppAdGroupFieldEnum.class) && v.getValue()
                        .equals(mobileAppAdGroupFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static AdGroupAnyFieldEnum fromDynamicTextAdGroupFieldEnum(
            DynamicTextAdGroupFieldEnum dynamicTextAdGroupFieldEnum) {
        return Arrays.stream(AdGroupAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(DynamicTextAdGroupFieldEnum.class) && v.getValue()
                        .equals(dynamicTextAdGroupFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static AdGroupAnyFieldEnum fromDynamicTextFeedAdGroupFieldEnum(
            DynamicTextFeedAdGroupFieldEnum dynamicTextFeedAdGroupFieldEnum) {
        return Arrays.stream(AdGroupAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(DynamicTextFeedAdGroupFieldEnum.class) && v.getValue()
                        .equals(dynamicTextFeedAdGroupFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static AdGroupAnyFieldEnum fromSmartAdGroupFieldEnum(SmartAdGroupFieldEnum smartAdGroupFieldEnum) {
        Predicate<AdGroupAnyFieldEnum> isSmartAdGroupFieldEnum =
                v -> v.getEnumClass().equals(SmartAdGroupFieldEnum.class) && v.getValue() == smartAdGroupFieldEnum;
        return Arrays.stream(AdGroupAnyFieldEnum.values())
                .filter(isSmartAdGroupFieldEnum)
                .findFirst()
                .orElseThrow(IllegalStateException::new);
    }

    public static AdGroupAnyFieldEnum fromContentPromotionAdGroupFieldEnum(
            ContentPromotionAdGroupFieldEnum contentPromotionAdGroupFieldEnum) {
        return Arrays.stream(AdGroupAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(ContentPromotionAdGroupFieldEnum.class) && v.getValue()
                        .equals(contentPromotionAdGroupFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static AdGroupAnyFieldEnum fromTextAdGroupFeedParamsFieldEnum(TextAdGroupFeedParamsFieldEnum textAdGroupFeedParamsFieldEnum) {
        return Arrays.stream(AdGroupAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(TextAdGroupFeedParamsFieldEnum.class) && v.getValue().equals(textAdGroupFeedParamsFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public Class<?> getEnumClass() {
        return enumClass;
    }

    public Enum getValue() {
        return value;
    }
}
