package ru.yandex.direct.api.v5.entity.adgroups.delegate

import ru.yandex.direct.api.v5.converter.ResultConverter
import ru.yandex.direct.api.v5.entity.OperationOnListDelegate
import ru.yandex.direct.api.v5.entity.adgroups.AdGroupsEndpoint
import ru.yandex.direct.api.v5.entity.adgroups.container.AdGroupsContainer
import ru.yandex.direct.api.v5.entity.adgroups.operation.AdGroupsProcessingTypeSupportFacade
import ru.yandex.direct.api.v5.entity.adgroups.validation.AdGroupsInternalRequestValidationTypeSupportFacade
import ru.yandex.direct.api.v5.result.ApiMassResult
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.core.entity.feature.service.FeatureService
import ru.yandex.direct.regions.GeoTreeFactory
import ru.yandex.direct.validation.result.PathConverter

abstract class AdGroupsDelegate<Req, Resp>(
    pathConverter: PathConverter,
    apiAuthenticationSource: ApiAuthenticationSource,
    ppcPropertiesSupport: PpcPropertiesSupport,
    featureService: FeatureService,
    private val geoTreeFactory: GeoTreeFactory,
    private val validationFacade: AdGroupsInternalRequestValidationTypeSupportFacade,
    private val processingFacade: AdGroupsProcessingTypeSupportFacade,
    protected val resultConverter: ResultConverter
) : OperationOnListDelegate<Req, Resp, AdGroupsContainer, Long>(
    pathConverter,
    apiAuthenticationSource,
    ppcPropertiesSupport,
    featureService
) {
    override fun validateInternalRequest(internalRequest: List<AdGroupsContainer>) =
        validationFacade.validate(internalRequest)

    override fun processList(validItems: List<AdGroupsContainer>): ApiMassResult<Long> {
        val operatorUid = auth.operator.uid
        val clientId = auth.chiefSubclient.clientId
        return resultConverter.toApiMassResult(
            processingFacade.process(operatorUid, clientId, geoTreeFactory.apiGeoTree, validItems),
            AdGroupsEndpoint.DEFECT_PRESENTATIONS)
    }
}
