package ru.yandex.direct.api.v5.entity.adgroups.delegate

import com.yandex.direct.api.v5.adgroups.AddRequest
import com.yandex.direct.api.v5.adgroups.AddResponse
import org.springframework.stereotype.Service
import ru.yandex.direct.api.v5.converter.ResultConverter
import ru.yandex.direct.api.v5.entity.adgroups.AdGroupDefectTypes.maxAdGroupsPerAddRequest
import ru.yandex.direct.api.v5.entity.adgroups.AdGroupsEndpoint
import ru.yandex.direct.api.v5.entity.adgroups.Constants.MAX_ELEMENTS_PER_ADD
import ru.yandex.direct.api.v5.entity.adgroups.container.AdGroupsContainer
import ru.yandex.direct.api.v5.entity.adgroups.converter.AdGroupsAddRequestConverter
import ru.yandex.direct.api.v5.entity.adgroups.operation.AdGroupsProcessingTypeSupportFacade
import ru.yandex.direct.api.v5.entity.adgroups.validation.AdGroupsInternalRequestValidationTypeSupportFacade
import ru.yandex.direct.api.v5.result.ApiResult
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource
import ru.yandex.direct.api.v5.validation.DefectType
import ru.yandex.direct.api.v5.validation.constraints.Constraints.eachNotNull
import ru.yandex.direct.api.v5.validation.constraints.Constraints.maxListSize
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.core.entity.feature.service.FeatureService
import ru.yandex.direct.regions.GeoTreeFactory
import ru.yandex.direct.validation.builder.ItemValidationBuilder
import ru.yandex.direct.validation.result.ValidationResult

@Service
class AddAdGroupsDelegate constructor(
    auth: ApiAuthenticationSource,
    ppcPropertiesSupport: PpcPropertiesSupport,
    featureService: FeatureService,
    geoTreeFactory: GeoTreeFactory,
    validatorFacade: AdGroupsInternalRequestValidationTypeSupportFacade,
    processingFacade: AdGroupsProcessingTypeSupportFacade,
    resultConverter: ResultConverter,
    private val requestConverter: AdGroupsAddRequestConverter
) : AdGroupsDelegate<AddRequest, AddResponse>(
    AdGroupsEndpoint.ADD_PATH_CONVERTER, auth, ppcPropertiesSupport, featureService,
    geoTreeFactory, validatorFacade, processingFacade, resultConverter
) {
    override fun validateRequest(externalRequest: AddRequest): ValidationResult<AddRequest, DefectType> {
        val vb = ItemValidationBuilder.of<AddRequest, DefectType>(externalRequest)
        vb.item(externalRequest.adGroups, AddRequest.PropInfo.AD_GROUPS.propertyName)
            .check(eachNotNull())
            .check(maxListSize(MAX_ELEMENTS_PER_ADD), maxAdGroupsPerAddRequest(MAX_ELEMENTS_PER_ADD))
        return vb.result
    }

    override fun convertRequest(externalRequest: AddRequest): List<AdGroupsContainer> =
        externalRequest.adGroups.map(requestConverter::convertItem)

    override fun convertResponse(result: ApiResult<List<ApiResult<Long>>>): AddResponse =
        AddResponse().withAddResults(resultConverter.toActionResults(result, apiPathConverter))
}
