package ru.yandex.direct.api.v5.entity.adgroups.delegate

import com.yandex.direct.api.v5.adgroups.UpdateRequest
import com.yandex.direct.api.v5.adgroups.UpdateResponse
import org.springframework.stereotype.Service
import ru.yandex.direct.api.v5.converter.ResultConverter
import ru.yandex.direct.api.v5.entity.adgroups.AdGroupDefectTypes.maxAdGroupsPerUpdateRequest
import ru.yandex.direct.api.v5.entity.adgroups.AdGroupsEndpoint
import ru.yandex.direct.api.v5.entity.adgroups.Constants.MAX_ELEMENTS_PER_UPDATE
import ru.yandex.direct.api.v5.entity.adgroups.container.AdGroupsContainer
import ru.yandex.direct.api.v5.entity.adgroups.converter.AdGroupsUpdateRequestConverter
import ru.yandex.direct.api.v5.entity.adgroups.operation.AdGroupsProcessingTypeSupportFacade
import ru.yandex.direct.api.v5.entity.adgroups.validation.AdGroupsInternalRequestValidationTypeSupportFacade
import ru.yandex.direct.api.v5.result.ApiResult
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource
import ru.yandex.direct.api.v5.validation.DefectType
import ru.yandex.direct.api.v5.validation.constraints.Constraints.maxListSize
import ru.yandex.direct.api.v5.ws.validation.InvalidSizeApiException
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService
import ru.yandex.direct.core.entity.feature.service.FeatureService
import ru.yandex.direct.regions.GeoTreeFactory
import ru.yandex.direct.validation.builder.ItemValidationBuilder
import ru.yandex.direct.validation.result.ValidationResult

@Service
class UpdateAdGroupsDelegate constructor(
    auth: ApiAuthenticationSource,
    ppcPropertiesSupport: PpcPropertiesSupport,
    featureService: FeatureService,
    geoTreeFactory: GeoTreeFactory,
    validatorFacade: AdGroupsInternalRequestValidationTypeSupportFacade,
    processingFacade: AdGroupsProcessingTypeSupportFacade,
    resultConverter: ResultConverter,
    private val requestConverter: AdGroupsUpdateRequestConverter,
    private val adGroupService: AdGroupService
) : AdGroupsDelegate<UpdateRequest, UpdateResponse>(
    AdGroupsEndpoint.UPDATE_PATH_CONVERTER, auth, ppcPropertiesSupport, featureService,
    geoTreeFactory, validatorFacade, processingFacade, resultConverter
) {
    override fun validateRequest(externalRequest: UpdateRequest): ValidationResult<UpdateRequest, DefectType> {
        // DIRECT-78286
        // TODO kaerber временный хак, по какой-то причине AdGroups.NegativeKeywords.Items не валидируются по WSDL
        if (externalRequest.adGroups.any { it.negativeKeywords?.value?.items?.size == 0 }) {
            throw InvalidSizeApiException("AdGroups.NegativeKeywords.Items", 1, Int.MAX_VALUE)
        }

        val vb = ItemValidationBuilder.of<UpdateRequest, DefectType>(externalRequest)
        vb.list(externalRequest.adGroups, "AdGroups")
            .check(maxListSize(MAX_ELEMENTS_PER_UPDATE), maxAdGroupsPerUpdateRequest(MAX_ELEMENTS_PER_UPDATE))
        return vb.result
    }

    override fun convertRequest(externalRequest: UpdateRequest): List<AdGroupsContainer> {
        val clientId = auth.subclient.clientId
        val adGroupIds = externalRequest.adGroups.map { it.id }
        val adGroupById = adGroupService.getAdGroups(clientId, adGroupIds)
            .also { adGroupService.enrichPerformanceAdGroups(clientId, it) }
            .associateBy { it.id }
        return externalRequest.adGroups.map { requestConverter.convert(it, adGroupById[it.id]) }
    }

    override fun convertResponse(result: ApiResult<List<ApiResult<Long>>>): UpdateResponse =
        UpdateResponse()
            .withUpdateResults(resultConverter.toActionResults(result, apiPathConverter))
}
