package ru.yandex.direct.api.v5.entity.adgroups.operation

import org.springframework.stereotype.Component
import ru.yandex.direct.api.v5.entity.adgroups.container.AdGroupsContainer
import ru.yandex.direct.api.v5.entity.adgroups.operation.type.AdGroupsOperationCreationTypeSupport
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.operation.aggregator.SplitAndMergeOperationAggregator
import ru.yandex.direct.regions.GeoTree
import ru.yandex.direct.result.MassResult

@Component
class AdGroupsProcessingTypeSupportFacade(operationCreators: List<AdGroupsOperationCreationTypeSupport<*>>) {
    private val operationCreatorByType = operationCreators.associateBy { it.typeClass }

    fun process(operatorUid: Long, clientId: ClientId, geoTree: GeoTree, validItems: List<AdGroupsContainer>): MassResult<Long> {
        val splitAndMergeOperationAggregatorBuilder = SplitAndMergeOperationAggregator
            .builderForPartialOperations(AdGroupsContainer::class.java, Long::class.java)
        validItems
            .asSequence()
            .map { it.javaClass }
            .distinct()
            .forEach { type ->
                val operationCreator = operationCreatorByType[type]
                    ?: throw IllegalStateException("no operation creation type support for $type")
                splitAndMergeOperationAggregatorBuilder
                    .addSubOperation({ item -> type.isAssignableFrom(item::class.java) }) { items ->
                        createOperation(operationCreator, operatorUid, clientId, geoTree, items)
                    }
            }
        return splitAndMergeOperationAggregatorBuilder.build()
            .execute(validItems)
    }

    private fun <T : AdGroupsContainer> createOperation(operationCreator: AdGroupsOperationCreationTypeSupport<T>,
                                                        operatorUid: Long, clientId: ClientId, geoTree: GeoTree,
                                                        items: List<AdGroupsContainer>) =
        operationCreator.createOperation(operatorUid, clientId, geoTree, @Suppress("UNCHECKED_CAST") (items as List<T>))
}
