package ru.yandex.direct.api.v5.entity.adgroups.operation.type

import org.springframework.stereotype.Component
import ru.yandex.direct.api.v5.entity.adgroups.container.AddAdGroupsComplexPerformanceContainer
import ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupAddOperationFactory
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.operation.Applicability
import ru.yandex.direct.operation.Operation
import ru.yandex.direct.regions.GeoTree

@Component
class AddAdGroupsComplexPerformanceOperationCreationTypeSupport(
    private val complexAdGroupAddOperationFactory: ComplexAdGroupAddOperationFactory
) : AdGroupsOperationCreationTypeSupport<AddAdGroupsComplexPerformanceContainer> {
    override fun getTypeClass() = AddAdGroupsComplexPerformanceContainer::class.java

    override fun createOperation(operatorUid: Long, clientId: ClientId, geoTree: GeoTree, validItems: List<AddAdGroupsComplexPerformanceContainer>): Operation<Long> =
        complexAdGroupAddOperationFactory.createPerformanceAdGroupAddOperation(Applicability.PARTIAL, true,
            validItems.map { it.complexAdGroup }, geoTree, operatorUid, clientId)
}
