package ru.yandex.direct.api.v5.entity.adgroups.operation.type

import org.springframework.stereotype.Component
import ru.yandex.direct.api.v5.entity.adgroups.container.AddAdGroupsSimpleContainer
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseValidator
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.operation.Applicability
import ru.yandex.direct.operation.Operation
import ru.yandex.direct.regions.GeoTree

@Component
class AddAdGroupsSimpleOperationCreationTypeSupport(
    private val adGroupService: AdGroupService
) : AdGroupsOperationCreationTypeSupport<AddAdGroupsSimpleContainer> {
    override fun getTypeClass() = AddAdGroupsSimpleContainer::class.java

    override fun createOperation(operatorUid: Long, clientId: ClientId, geoTree: GeoTree, validItems: List<AddAdGroupsSimpleContainer>): Operation<Long> =
        adGroupService.createAddOperation(validItems.map { it.adGroup }, geoTree,
            MinusPhraseValidator.ValidationMode.ONE_ERROR_PER_TYPE, operatorUid, clientId, Applicability.PARTIAL,
            true, true)
}
