package ru.yandex.direct.api.v5.entity.adgroups.operation.type

import org.springframework.stereotype.Component
import ru.yandex.direct.api.v5.entity.adgroups.container.UpdateAdGroupsComplexPerformanceContainer
import ru.yandex.direct.core.entity.adgroup.service.ModerationMode
import ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupUpdateOperationFactory
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.operation.Applicability
import ru.yandex.direct.operation.Operation
import ru.yandex.direct.regions.GeoTree

@Component
class UpdateAdGroupsComplexPerformanceOperationCreationTypeSupport(
    private val complexAdGroupUpdateOperationFactory: ComplexAdGroupUpdateOperationFactory
) : AdGroupsOperationCreationTypeSupport<UpdateAdGroupsComplexPerformanceContainer> {
    override fun getTypeClass() = UpdateAdGroupsComplexPerformanceContainer::class.java

    override fun createOperation(operatorUid: Long, clientId: ClientId, geoTree: GeoTree, validItems: List<UpdateAdGroupsComplexPerformanceContainer>): Operation<Long> =
        complexAdGroupUpdateOperationFactory.createComplexPerformanceAdGroupUpdateOperation(Applicability.PARTIAL,
            validItems.map { it.complexAdGroup }, geoTree, false, operatorUid, clientId, ModerationMode.DEFAULT)
}
