package ru.yandex.direct.api.v5.entity.adgroups.operation.type

import org.springframework.stereotype.Component
import ru.yandex.direct.api.v5.entity.adgroups.container.UpdateAdGroupsSimpleContainer
import ru.yandex.direct.core.entity.adgroup.container.AdGroupUpdateOperationParams
import ru.yandex.direct.core.entity.adgroup.model.AdGroup
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService
import ru.yandex.direct.core.entity.adgroup.service.ModerationMode
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseValidator
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.operation.Applicability
import ru.yandex.direct.operation.Operation
import ru.yandex.direct.regions.GeoTree

@Component
class UpdateAdGroupsSimpleOperationCreationTypeSupport(
    private val adGroupService: AdGroupService
) : AdGroupsOperationCreationTypeSupport<UpdateAdGroupsSimpleContainer> {
    override fun getTypeClass() = UpdateAdGroupsSimpleContainer::class.java

    override fun createOperation(operatorUid: Long, clientId: ClientId, geoTree: GeoTree, validItems: List<UpdateAdGroupsSimpleContainer>): Operation<Long> {
        val operationParams = AdGroupUpdateOperationParams.builder()
            .withModerationMode(ModerationMode.DEFAULT)
            .withValidateInterconnections(true)
            .build()
        return adGroupService.createUpdateOperation(validItems.map { it.modelChanges.castModelUp(AdGroup::class.java) },
            operationParams, geoTree, MinusPhraseValidator.ValidationMode.ONE_ERROR_PER_TYPE, operatorUid, clientId,
            Applicability.PARTIAL)
    }
}
