package ru.yandex.direct.api.v5.entity.adgroups.validation.type

import org.springframework.stereotype.Component
import ru.yandex.direct.api.v5.entity.adgroups.AdGroupDefectTypes.hyperGeoSettingsWasFlushed
import ru.yandex.direct.api.v5.entity.adgroups.container.UpdateAdGroupsComplexPerformanceContainer
import ru.yandex.direct.api.v5.validation.DefectType
import ru.yandex.direct.validation.builder.Constraint
import ru.yandex.direct.validation.builder.ItemValidationBuilder

@Component
class UpdateAdGroupsComplexPerformanceInternalRequestValidationTypeSupport : AdGroupsInternalRequestValidationTypeSupport<UpdateAdGroupsComplexPerformanceContainer> {
    override fun getTypeClass() = UpdateAdGroupsComplexPerformanceContainer::class.java

    override fun validate(items: List<UpdateAdGroupsComplexPerformanceContainer>) = items.map(this::validateItem)

    private fun validateItem(item: UpdateAdGroupsComplexPerformanceContainer) =
        ItemValidationBuilder.of<UpdateAdGroupsComplexPerformanceContainer, DefectType>(item)
            .weakCheck(hyperGeoSettingIsNotFlushed())
            .result

    private fun hyperGeoSettingIsNotFlushed(): Constraint<UpdateAdGroupsComplexPerformanceContainer, DefectType> {
        return Constraint.fromPredicate({ request ->
            request.oldAdGroup?.hyperGeoId == null || request.complexAdGroup.adGroup.hyperGeoId != null
        }, hyperGeoSettingsWasFlushed())
    }
}
