package ru.yandex.direct.api.v5.entity.ads;

import com.yandex.direct.api.v5.ads.AddRequest;
import com.yandex.direct.api.v5.ads.AddResponse;
import com.yandex.direct.api.v5.ads.AdsPort;
import com.yandex.direct.api.v5.ads.ApiException;
import com.yandex.direct.api.v5.ads.ArchiveRequest;
import com.yandex.direct.api.v5.ads.ArchiveResponse;
import com.yandex.direct.api.v5.ads.DeleteRequest;
import com.yandex.direct.api.v5.ads.DeleteResponse;
import com.yandex.direct.api.v5.ads.GetRequest;
import com.yandex.direct.api.v5.ads.GetResponse;
import com.yandex.direct.api.v5.ads.ModerateRequest;
import com.yandex.direct.api.v5.ads.ModerateResponse;
import com.yandex.direct.api.v5.ads.ResumeRequest;
import com.yandex.direct.api.v5.ads.ResumeResponse;
import com.yandex.direct.api.v5.ads.SuspendRequest;
import com.yandex.direct.api.v5.ads.SuspendResponse;
import com.yandex.direct.api.v5.ads.UnarchiveRequest;
import com.yandex.direct.api.v5.ads.UnarchiveResponse;
import com.yandex.direct.api.v5.ads.UpdateRequest;
import com.yandex.direct.api.v5.ads.UpdateResponse;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.ads.delegate.AddAdsDelegate;
import ru.yandex.direct.api.v5.entity.ads.delegate.ArchiveAdsDelegate;
import ru.yandex.direct.api.v5.entity.ads.delegate.DeleteAdsDelegate;
import ru.yandex.direct.api.v5.entity.ads.delegate.GetAdsDelegate;
import ru.yandex.direct.api.v5.entity.ads.delegate.ModerateAdsDelegate;
import ru.yandex.direct.api.v5.entity.ads.delegate.ResumeAdsDelegate;
import ru.yandex.direct.api.v5.entity.ads.delegate.SuspendAdsDelegate;
import ru.yandex.direct.api.v5.entity.ads.delegate.UnarchiveAdsDelegate;
import ru.yandex.direct.api.v5.entity.ads.delegate.UpdateAdsDelegate;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;
import ru.yandex.direct.validation.result.MappingPathConverter;
import ru.yandex.direct.validation.result.PathConverter;

/**
 * Сервис по работе с рекламными объявлениями.
 *
 * @see <a href=https://tech.yandex.ru/direct/doc/ref-v5/ads/ads-docpage/>Ads API tech docs</a>
 */
@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.CLIENT)
public class AdsEndpoint implements AdsPort {

    private static final String SERVICE_NAME = "ads";

    public static final PathConverter PATH_CONVERTER =
            MappingPathConverter.builder(AdsEndpoint.class, "capitalize")
                    .add(ApiPathConverter.getCommonDict())
                    .build();

    private final GenericApiService genericApiService;
    private final AddAdsDelegate addAdsDelegate;
    private final GetAdsDelegate getAdsDelegate;
    private final DeleteAdsDelegate deleteAdsDelegate;
    private final UpdateAdsDelegate updateAdsDelegate;
    private final ResumeAdsDelegate resumeAdsDelegate;
    private final SuspendAdsDelegate suspendAdsDelegate;
    private final ArchiveAdsDelegate archiveAdsDelegate;
    private final UnarchiveAdsDelegate unarchiveAdsDelegate;
    private final ModerateAdsDelegate moderateAdsDelegate;

    @Autowired
    public AdsEndpoint(
            GenericApiService genericApiService,
            AddAdsDelegate addAdsDelegate,
            GetAdsDelegate getAdsDelegate,
            DeleteAdsDelegate deleteAdsDelegate,
            UpdateAdsDelegate updateAdsDelegate,
            ResumeAdsDelegate resumeAdsDelegate,
            SuspendAdsDelegate suspendAdsDelegate,
            ArchiveAdsDelegate archiveAdsDelegate,
            UnarchiveAdsDelegate unarchiveAdsDelegate,
            ModerateAdsDelegate moderateAdsDelegate) {
        this.genericApiService = genericApiService;
        this.addAdsDelegate = addAdsDelegate;
        this.getAdsDelegate = getAdsDelegate;
        this.deleteAdsDelegate = deleteAdsDelegate;
        this.updateAdsDelegate = updateAdsDelegate;
        this.resumeAdsDelegate = resumeAdsDelegate;
        this.suspendAdsDelegate = suspendAdsDelegate;
        this.archiveAdsDelegate = archiveAdsDelegate;
        this.unarchiveAdsDelegate = unarchiveAdsDelegate;
        this.moderateAdsDelegate = moderateAdsDelegate;
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest parameters) throws ApiException {
        return genericApiService.doAction(getAdsDelegate, parameters);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "add")
    @ApiResponse
    @Override
    public AddResponse add(@ApiRequest AddRequest parameters) {
        return genericApiService.doAction(addAdsDelegate, parameters);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "update")
    @ApiResponse
    @Override
    public UpdateResponse update(@ApiRequest UpdateRequest parameters) {
        return genericApiService.doAction(updateAdsDelegate, parameters);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "delete")
    @ApiResponse
    @Override
    public DeleteResponse delete(@ApiRequest DeleteRequest parameters) {
        return genericApiService.doAction(deleteAdsDelegate, parameters);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "archive")
    @ApiResponse
    @Override
    public ArchiveResponse archive(@ApiRequest ArchiveRequest parameters) {
        return genericApiService.doAction(archiveAdsDelegate, parameters);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "unarchive")
    @ApiResponse
    @Override
    public UnarchiveResponse unarchive(@ApiRequest UnarchiveRequest parameters) {
        return genericApiService.doAction(unarchiveAdsDelegate, parameters);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "suspend")
    @ApiResponse
    @Override
    public SuspendResponse suspend(@ApiRequest SuspendRequest parameters) {
        return genericApiService.doAction(suspendAdsDelegate, parameters);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "resume")
    @ApiResponse
    @Override
    public ResumeResponse resume(@ApiRequest ResumeRequest parameters) {
        return genericApiService.doAction(resumeAdsDelegate, parameters);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "moderate")
    @ApiResponse
    @Override
    public ModerateResponse moderate(@ApiRequest ModerateRequest parameters) {
        return genericApiService.doAction(moderateAdsDelegate, parameters);
    }

    private static RuntimeException notImplementedYet() {
        return new UnsupportedOperationException("Not implemented yet.");
    }

}
