package ru.yandex.direct.api.v5.entity.ads;

import com.yandex.direct.api.v5.ads.AdUpdateItem;

import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.model.ModelChanges;

/**
 * Связка итема внешнего запроса и соответствующего ему итема внутреннего запроса.
 *
 * @param <B> тип баннера
 */
public class AdsUpdateRequestItem<B extends BannerWithSystemFields> {

    private final AdUpdateItem adUpdateItemExternal;
    private final ModelChanges<B> adUpdateItemInternal;

    public AdsUpdateRequestItem(AdUpdateItem adUpdateItemExternal, ModelChanges<B> adUpdateItemInternal) {
        this.adUpdateItemExternal = adUpdateItemExternal;
        this.adUpdateItemInternal = adUpdateItemInternal;
    }

    public AdUpdateItem getExternalItem() {
        return adUpdateItemExternal;
    }

    public ModelChanges<B> getInternalItem() {
        return adUpdateItemInternal;
    }

    public Long getBannerId() {
        return adUpdateItemInternal.getId();
    }
}
