package ru.yandex.direct.api.v5.entity.ads;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.ads.AgeLabelEnum;
import one.util.streamex.StreamEx;

@ParametersAreNonnullByDefault
public class Constants {

    private Constants() {
    }

    public static final int MAX_ELEMENTS_PER_ADD = 1_000;
    public static final int MAX_ELEMENTS_PER_UPDATE = 1_000;
    public static final int MAX_ADGROUP_IDS_COUNT = 1000;
    public static final int MAX_CAMPAIGN_IDS_COUNT = 10;
    public static final int MAX_IDS_PER_DELETE = 10_000;
    public static final int MAX_IDS_PER_MODERATE = 10_000;
    public static final int MAX_SUSPEND_RESUME_IDS_COUNT = 10_000;
    public static final int MAX_ARCHIVE_UNARCHIVE_IDS_COUNT = 10_000;

    public static final String BABY_FOOD_VALUES = StreamEx.of(
            AgeLabelEnum.MONTHS_0.name(), "...", AgeLabelEnum.MONTHS_12.name())
            .joining(", ");
    public static final String AGE_VALUES = StreamEx.of(AgeLabelEnum.values())
            .map(Enum::name)
            .filter(name -> name.startsWith("AGE_"))
            .joining(", ");
}
