package ru.yandex.direct.api.v5.entity.ads.converter;

import java.util.Collection;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.adextensiontypes.AdExtensionTypeEnum;
import com.yandex.direct.api.v5.ads.AdExtensionAdGetItem;
import com.yandex.direct.api.v5.ads.ObjectFactory;

import static java.util.Collections.emptyList;
import static java.util.stream.Collectors.toList;

@ParametersAreNonnullByDefault
class AdExtensionsConverter {

    private static final ObjectFactory FACTORY = new ObjectFactory();

    static Collection<AdExtensionAdGetItem> convertAdExtensions(@Nullable Collection<Long> calloutIds) {
        if (calloutIds == null) {
            return emptyList();
        }

        return calloutIds.stream().map(e -> FACTORY.createAdExtensionAdGetItem().withAdExtensionId(e)
                .withType(AdExtensionTypeEnum.CALLOUT)).collect(toList());
    }
}
