package ru.yandex.direct.api.v5.entity.ads.converter;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.ads.ArchiveRequest;
import com.yandex.direct.api.v5.ads.UnarchiveRequest;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.model.ModelChanges;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
@ParametersAreNonnullByDefault
public class AdsArchiveUnarchiveRequestConverter {
    public List<ModelChanges<BannerWithSystemFields>> convertArchive(ArchiveRequest request) {
        return mapList(request.getSelectionCriteria().getIds(),
                id -> new ModelChanges<>(id, BannerWithSystemFields.class).process(Boolean.TRUE,
                        BannerWithSystemFields.STATUS_ARCHIVED));
    }

    public List<ModelChanges<BannerWithSystemFields>> convertUnarchive(UnarchiveRequest request) {
        return mapList(request.getSelectionCriteria().getIds(),
                id -> new ModelChanges<>(id, BannerWithSystemFields.class).process(Boolean.FALSE,
                        BannerWithSystemFields.STATUS_ARCHIVED));
    }
}
