package ru.yandex.direct.api.v5.entity.ads.converter;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.ads.ResumeRequest;
import com.yandex.direct.api.v5.ads.SuspendRequest;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.model.ModelChanges;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
@ParametersAreNonnullByDefault
public class AdsSuspendResumeRequestConverter {
    public List<ModelChanges<BannerWithSystemFields>> convertSuspend(SuspendRequest request) {
        return mapList(request.getSelectionCriteria().getIds(),
                id -> new ModelChanges<>(id, BannerWithSystemFields.class)
                        .process(Boolean.FALSE, BannerWithSystemFields.STATUS_SHOW));
    }

    public List<ModelChanges<BannerWithSystemFields>> convertResume(ResumeRequest request) {
        return mapList(request.getSelectionCriteria().getIds(),
                id -> new ModelChanges<>(id, BannerWithSystemFields.class)
                        .process(Boolean.TRUE, BannerWithSystemFields.STATUS_SHOW));
    }
}
