package ru.yandex.direct.api.v5.entity.ads.converter;

import java.util.Map;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.xml.bind.JAXBElement;

import com.google.common.collect.ImmutableMap;
import com.yandex.direct.api.v5.ads.AgeLabelEnum;
import com.yandex.direct.api.v5.ads.ObjectFactory;

import ru.yandex.direct.core.entity.banner.model.Age;
import ru.yandex.direct.core.entity.banner.model.BabyFood;
import ru.yandex.direct.core.entity.banner.model.BannerFlags;

@ParametersAreNonnullByDefault
class AgeLabelConverter {

    private static final ObjectFactory FACTORY = new ObjectFactory();

    private static final Map<String, AgeLabelEnum> AGE_LABELS =
            ImmutableMap.<String, AgeLabelEnum>builder()
                    .put(Age.AGE_0.getValue(), AgeLabelEnum.AGE_0)
                    .put(Age.AGE_6.getValue(), AgeLabelEnum.AGE_6)
                    .put(Age.AGE_12.getValue(), AgeLabelEnum.AGE_12)
                    .put(Age.AGE_16.getValue(), AgeLabelEnum.AGE_16)
                    .put(Age.AGE_18.getValue(), AgeLabelEnum.AGE_18)
                    .build();

    private static final Map<String, AgeLabelEnum> MONTH_LABELS =
            ImmutableMap.<String, AgeLabelEnum>builder()
                    .put(BabyFood.BABY_FOOD_0.getTypedValue(), AgeLabelEnum.MONTHS_0)
                    .put(BabyFood.BABY_FOOD_1.getTypedValue(), AgeLabelEnum.MONTHS_1)
                    .put(BabyFood.BABY_FOOD_2.getTypedValue(), AgeLabelEnum.MONTHS_2)
                    .put(BabyFood.BABY_FOOD_3.getTypedValue(), AgeLabelEnum.MONTHS_3)
                    .put(BabyFood.BABY_FOOD_4.getTypedValue(), AgeLabelEnum.MONTHS_4)
                    .put(BabyFood.BABY_FOOD_5.getTypedValue(), AgeLabelEnum.MONTHS_5)
                    .put(BabyFood.BABY_FOOD_6.getTypedValue(), AgeLabelEnum.MONTHS_6)
                    .put(BabyFood.BABY_FOOD_7.getTypedValue(), AgeLabelEnum.MONTHS_7)
                    .put(BabyFood.BABY_FOOD_8.getTypedValue(), AgeLabelEnum.MONTHS_8)
                    .put(BabyFood.BABY_FOOD_9.getTypedValue(), AgeLabelEnum.MONTHS_9)
                    .put(BabyFood.BABY_FOOD_10.getTypedValue(), AgeLabelEnum.MONTHS_10)
                    .put(BabyFood.BABY_FOOD_11.getTypedValue(), AgeLabelEnum.MONTHS_11)
                    .put(BabyFood.BABY_FOOD_12.getTypedValue(), AgeLabelEnum.MONTHS_12)
                    .build();

    static JAXBElement<AgeLabelEnum> convertAgeLabel(@Nullable BannerFlags bannerFlags) {
        AgeLabelEnum result = null;

        if (bannerFlags != null) {
            Age age = bannerFlags.get(BannerFlags.AGE);
            if (age != null) {
                result = AGE_LABELS.get(age.getValue());
            } else {
                BabyFood babyFood = bannerFlags.get(BannerFlags.BABY_FOOD);
                if (babyFood != null) {
                    result = MONTH_LABELS.get(babyFood.getTypedValue());
                }
            }
        }

        return FACTORY.createAdGetItemAgeLabel(result);
    }
}
