package ru.yandex.direct.api.v5.entity.ads.converter;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.ads.AgeLabelEnum;
import com.yandex.direct.api.v5.ads.MobAppAgeLabelEnum;

import ru.yandex.direct.core.entity.banner.model.Age;
import ru.yandex.direct.core.entity.banner.model.BabyFood;
import ru.yandex.direct.core.entity.banner.model.BannerFlags;
import ru.yandex.direct.core.entity.banner.model.FlagProperty;

@ParametersAreNonnullByDefault
class BannerFlagsConverter {

    private BannerFlagsConverter() {
        // no instantiation
    }

    @Nullable
    static BannerFlags toCoreBannerFlagsUpdate(@Nullable MobAppAgeLabelEnum ageLabelEnum,
                                               @Nullable BannerFlags oldFlags,
                                               boolean canChangeBannerFlags) {
        if (ageLabelEnum == null) {
            return null;
        }

        final BannerFlags result = new BannerFlags();
        if (oldFlags != null) {
            result.withFlags(oldFlags.getFlags());
        }

        switch (ageLabelEnum) {
            case AGE_0:
                return setFlagIfWasPresented(result, BannerFlags.AGE, Age.AGE_0, canChangeBannerFlags);
            case AGE_6:
                return setFlagIfWasPresented(result, BannerFlags.AGE, Age.AGE_6, canChangeBannerFlags);
            case AGE_12:
                return setFlagIfWasPresented(result, BannerFlags.AGE, Age.AGE_12, canChangeBannerFlags);
            case AGE_16:
                return setFlagIfWasPresented(result, BannerFlags.AGE, Age.AGE_16, canChangeBannerFlags);
            case AGE_18:
                return setFlagIfWasPresented(result, BannerFlags.AGE, Age.AGE_18, canChangeBannerFlags);

            default:
                throw new IllegalArgumentException("unknown age label enum: " + ageLabelEnum);
        }
    }

    @Nullable
    static BannerFlags toCoreBannerFlagsUpdate(@Nullable AgeLabelEnum ageLabelEnum,
                                               @Nullable BannerFlags oldFlags,
                                               boolean canChangeBannerFlags) {
        if (ageLabelEnum == null) {
            return null;
        }

        final BannerFlags result = new BannerFlags();
        if (oldFlags != null) {
            result.withFlags(oldFlags.getFlags());
        }

        switch (ageLabelEnum) {
            case MONTHS_0:
                return setFlagIfWasPresented(result, BannerFlags.BABY_FOOD, BabyFood.BABY_FOOD_0, canChangeBannerFlags);
            case MONTHS_1:
                return setFlagIfWasPresented(result, BannerFlags.BABY_FOOD, BabyFood.BABY_FOOD_1, canChangeBannerFlags);
            case MONTHS_2:
                return setFlagIfWasPresented(result, BannerFlags.BABY_FOOD, BabyFood.BABY_FOOD_2, canChangeBannerFlags);
            case MONTHS_3:
                return setFlagIfWasPresented(result, BannerFlags.BABY_FOOD, BabyFood.BABY_FOOD_3, canChangeBannerFlags);
            case MONTHS_4:
                return setFlagIfWasPresented(result, BannerFlags.BABY_FOOD, BabyFood.BABY_FOOD_4, canChangeBannerFlags);
            case MONTHS_5:
                return setFlagIfWasPresented(result, BannerFlags.BABY_FOOD, BabyFood.BABY_FOOD_5, canChangeBannerFlags);
            case MONTHS_6:
                return setFlagIfWasPresented(result, BannerFlags.BABY_FOOD, BabyFood.BABY_FOOD_6, canChangeBannerFlags);
            case MONTHS_7:
                return setFlagIfWasPresented(result, BannerFlags.BABY_FOOD, BabyFood.BABY_FOOD_7, canChangeBannerFlags);
            case MONTHS_8:
                return setFlagIfWasPresented(result, BannerFlags.BABY_FOOD, BabyFood.BABY_FOOD_8, canChangeBannerFlags);
            case MONTHS_9:
                return setFlagIfWasPresented(result, BannerFlags.BABY_FOOD, BabyFood.BABY_FOOD_9, canChangeBannerFlags);
            case MONTHS_10:
                return setFlagIfWasPresented(result, BannerFlags.BABY_FOOD, BabyFood.BABY_FOOD_10,
                        canChangeBannerFlags);
            case MONTHS_11:
                return setFlagIfWasPresented(result, BannerFlags.BABY_FOOD, BabyFood.BABY_FOOD_11,
                        canChangeBannerFlags);
            case MONTHS_12:
                return setFlagIfWasPresented(result, BannerFlags.BABY_FOOD, BabyFood.BABY_FOOD_12,
                        canChangeBannerFlags);
            case AGE_0:
                return setFlagIfWasPresented(result, BannerFlags.AGE, Age.AGE_0, canChangeBannerFlags);
            case AGE_6:
                return setFlagIfWasPresented(result, BannerFlags.AGE, Age.AGE_6, canChangeBannerFlags);
            case AGE_12:
                return setFlagIfWasPresented(result, BannerFlags.AGE, Age.AGE_12, canChangeBannerFlags);
            case AGE_16:
                return setFlagIfWasPresented(result, BannerFlags.AGE, Age.AGE_16, canChangeBannerFlags);
            case AGE_18:
                return setFlagIfWasPresented(result, BannerFlags.AGE, Age.AGE_18, canChangeBannerFlags);

            default:
                throw new IllegalArgumentException("unknown age label enum: " + ageLabelEnum);
        }
    }

    private static <T> BannerFlags setFlagIfWasPresented(BannerFlags result, FlagProperty<T> property, T value,
                                                         boolean canChangeBannerFlags) {

        if (result.get(BannerFlags.BABY_FOOD) == null && result.get(BannerFlags.AGE) == null
                && !canChangeBannerFlags) {
            return result;
        }
        return result.with(property, value);
    }

    static Age toCoreBannerFlagsAdd(@Nullable MobAppAgeLabelEnum apiAge) {
        if (apiAge == null) {
            return Age.AGE_18;
        }

        switch (apiAge) {
            case AGE_0:
                return Age.AGE_0;
            case AGE_6:
                return Age.AGE_6;
            case AGE_12:
                return Age.AGE_12;
            case AGE_16:
                return Age.AGE_16;
            case AGE_18:
                return Age.AGE_18;
            default:
                throw new IllegalArgumentException("apiAge");
        }
    }
}
