package ru.yandex.direct.api.v5.entity.ads.converter;

import com.yandex.direct.api.v5.ads.ButtonExtensionAction;
import com.yandex.direct.api.v5.ads.ButtonExtensionGetItem;
import com.yandex.direct.api.v5.ads.ObjectFactory;
import com.yandex.direct.api.v5.general.ExtensionModeration;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.springframework.stereotype.Component;

import ru.yandex.direct.api.v5.entity.ads.StatusClarificationTranslations;
import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.core.entity.banner.model.BannerButtonStatusModerate;
import ru.yandex.direct.core.entity.banner.model.BannerWithButton;
import ru.yandex.direct.core.entity.banner.model.ButtonAction;

@Component
public class ButtonExtensionConverter {

    public ButtonExtensionGetItem convert(ObjectFactory factory, BannerWithButton bannerWithButton) {
        if (bannerWithButton.getButtonAction() == null) {
            return null;
        }

        var extension = factory.createButtonExtensionGetItem();
        extension.setAction(convertAction(bannerWithButton.getButtonAction()));
        extension.setCustomActionText(bannerWithButton.getButtonCaption());
        extension.setHref(bannerWithButton.getButtonHref());

        return extension;
    }

    public ButtonExtensionAction convertAction(ButtonAction buttonAction) {
        return ButtonExtensionAction.fromValue(buttonAction.name());
    }

    public ExtensionModeration convertButtonExtensionStatusModerate(
            BannerButtonStatusModerate statusModerate, TranslationService translationService

    ) {
        if (statusModerate == null) {
            return null;
        }
        ExtensionModeration extensionModeration = new ExtensionModeration();
        StatusClarificationTranslations translations = StatusClarificationTranslations.INSTANCE;

        switch (statusModerate) {
            case YES:
                return extensionModeration
                        .withStatus(StatusEnum.ACCEPTED)
                        .withStatusClarification(translationService.translate(translations.buttonExtensionAcceptedAtModeration()));
            case NO:
                return extensionModeration
                        .withStatus(StatusEnum.REJECTED)
                        .withStatusClarification(translationService.translate(translations
                                .buttonExtensionRejectedAtModeration()));
            case SENT:
            case SENDING:
            case READY:
                return extensionModeration
                        .withStatus(StatusEnum.MODERATION)
                        .withStatusClarification(translationService.translate(translations.buttonExtensionAwaitingModeration()));
            case NEW:
                return extensionModeration
                        .withStatus(StatusEnum.DRAFT)
                        .withStatusClarification(translationService.translate(translations.relatedObjectIsDraft()));
            default:
                return extensionModeration.withStatus(StatusEnum.UNKNOWN);
        }
    }

}
