package ru.yandex.direct.api.v5.entity.ads.converter;

import com.yandex.direct.api.v5.general.ExtensionModeration;
import com.yandex.direct.api.v5.general.StatusEnum;
import org.springframework.stereotype.Component;

import ru.yandex.direct.api.v5.entity.ads.StatusClarificationTranslations;
import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.core.entity.banner.model.BannerLogoStatusModerate;

@Component
public class LogoConverter {

    public ExtensionModeration convertLogoStatusModerate(
            BannerLogoStatusModerate statusModerate, TranslationService translationService

    ) {
        if (statusModerate == null) {
            return null;
        }
        ExtensionModeration extensionModeration = new ExtensionModeration();
        StatusClarificationTranslations translations = StatusClarificationTranslations.INSTANCE;

        switch (statusModerate) {
            case YES:
                return extensionModeration
                        .withStatus(StatusEnum.ACCEPTED)
                        .withStatusClarification(translationService.translate(translations.logoExtensionAcceptedAtModeration()));
            case NO:
                return extensionModeration
                        .withStatus(StatusEnum.REJECTED)
                        .withStatusClarification(translationService.translate(translations.logoExtensionRejectedAtModeration()));
            case SENT:
            case SENDING:
            case READY:
                return extensionModeration
                        .withStatus(StatusEnum.MODERATION)
                        .withStatusClarification(translationService.translate(translations.logoExtensionAwaitingModeration()));
            case NEW:
                return extensionModeration
                        .withStatus(StatusEnum.DRAFT)
                        .withStatusClarification(translationService.translate(translations.relatedObjectIsDraft()));
            default:
                return extensionModeration.withStatus(StatusEnum.UNKNOWN);
        }
    }

}
