package ru.yandex.direct.api.v5.entity.ads.converter;

import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableMap;
import com.yandex.direct.api.v5.general.MobileAppAdActionEnum;

import ru.yandex.direct.core.entity.banner.model.NewMobileContentPrimaryAction;

@ParametersAreNonnullByDefault
class MobileAppActionConverter {

    private static final Map<NewMobileContentPrimaryAction, MobileAppAdActionEnum> ACTIONS =
            ImmutableMap.<NewMobileContentPrimaryAction, MobileAppAdActionEnum>builder()
                    .put(NewMobileContentPrimaryAction.BUY, MobileAppAdActionEnum.BUY_AUTODETECT)
                    .put(NewMobileContentPrimaryAction.DOWNLOAD, MobileAppAdActionEnum.DOWNLOAD)
                    .put(NewMobileContentPrimaryAction.GET, MobileAppAdActionEnum.GET)
                    .put(NewMobileContentPrimaryAction.INSTALL, MobileAppAdActionEnum.INSTALL)
                    .put(NewMobileContentPrimaryAction.MORE, MobileAppAdActionEnum.MORE)
                    .put(NewMobileContentPrimaryAction.OPEN, MobileAppAdActionEnum.OPEN)
                    .put(NewMobileContentPrimaryAction.PLAY, MobileAppAdActionEnum.PLAY)
                    .put(NewMobileContentPrimaryAction.UPDATE, MobileAppAdActionEnum.UPDATE)
                    .build();

    static MobileAppAdActionEnum convertMobileAppAction(NewMobileContentPrimaryAction action) {
        MobileAppAdActionEnum externalAction = ACTIONS.get(action);

        if (externalAction == null) {
            throw new IllegalArgumentException("not supported mobile app ad action type: " + action);
        }

        return externalAction;
    }

}
