package ru.yandex.direct.api.v5.entity.ads.converter;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.general.MobileAppAdActionEnum;

import ru.yandex.direct.core.entity.banner.model.NewMobileContentPrimaryAction;

@ParametersAreNonnullByDefault
class PrimaryActionConverter {
    private PrimaryActionConverter() {
    }

    static NewMobileContentPrimaryAction toCorePrimaryAction(@Nullable MobileAppAdActionEnum apiPrimaryAction) {
        if (apiPrimaryAction == null) {
            return null;
        }

        switch (apiPrimaryAction) {
            case BUY_AUTODETECT:
                return NewMobileContentPrimaryAction.BUY;
            case DOWNLOAD:
                return NewMobileContentPrimaryAction.DOWNLOAD;
            case GET:
                return NewMobileContentPrimaryAction.GET;
            case INSTALL:
                return NewMobileContentPrimaryAction.INSTALL;
            case MORE:
                return NewMobileContentPrimaryAction.MORE;
            case OPEN:
                return NewMobileContentPrimaryAction.OPEN;
            case PLAY:
                return NewMobileContentPrimaryAction.PLAY;
            case UPDATE:
                return NewMobileContentPrimaryAction.UPDATE;
            default:
                throw new IllegalArgumentException("apiPrimaryAction: " + apiPrimaryAction);
        }
    }
}
