package ru.yandex.direct.api.v5.entity.ads.converter;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.ads.MobileAppAdFeatureItem;
import com.yandex.direct.api.v5.ads.MobileAppFeatureEnum;
import one.util.streamex.StreamEx;

import ru.yandex.direct.api.v5.common.GeneralUtil;
import ru.yandex.direct.core.entity.banner.model.NewReflectedAttribute;

@ParametersAreNonnullByDefault
class ReflectedAttrsConverter {
    private ReflectedAttrsConverter() {
    }

    static Map<NewReflectedAttribute, Boolean> toCoreReflectedAttrs(List<MobileAppAdFeatureItem> apiReflectedAttrs) {
        return StreamEx.of(apiReflectedAttrs)
                .toMap(ftr -> toCoreReflectedAttr(ftr.getFeature()),
                        ftr -> GeneralUtil.yesNoToBoolean(ftr.getEnabled()));
    }

    private static NewReflectedAttribute toCoreReflectedAttr(MobileAppFeatureEnum apiReflectedAttr) {
        switch (apiReflectedAttr) {
            case ICON:
                return NewReflectedAttribute.ICON;
            case PRICE:
                return NewReflectedAttribute.PRICE;
            case CUSTOMER_RATING:
                return NewReflectedAttribute.RATING;
            case RATINGS:
                return NewReflectedAttribute.RATING_VOTES;
            default:
                throw new IllegalArgumentException("apiReflectedAttr");
        }
    }
}
