package ru.yandex.direct.api.v5.entity.ads.delegate;

import java.util.Arrays;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.ads.AdFieldEnum;
import com.yandex.direct.api.v5.ads.ContentPromotionCollectionAdFieldEnum;
import com.yandex.direct.api.v5.ads.ContentPromotionEdaAdFieldEnum;
import com.yandex.direct.api.v5.ads.ContentPromotionServiceAdFieldEnum;
import com.yandex.direct.api.v5.ads.ContentPromotionVideoAdFieldEnum;
import com.yandex.direct.api.v5.ads.CpcVideoAdBuilderAdFieldEnum;
import com.yandex.direct.api.v5.ads.CpmBannerAdBuilderAdFieldEnum;
import com.yandex.direct.api.v5.ads.CpmVideoAdBuilderAdFieldEnum;
import com.yandex.direct.api.v5.ads.DynamicTextAdFieldEnum;
import com.yandex.direct.api.v5.ads.MobileAppAdBuilderAdFieldEnum;
import com.yandex.direct.api.v5.ads.MobileAppAdFieldEnum;
import com.yandex.direct.api.v5.ads.MobileAppCpcVideoAdBuilderAdFieldEnum;
import com.yandex.direct.api.v5.ads.MobileAppImageAdFieldEnum;
import com.yandex.direct.api.v5.ads.SmartAdBuilderAdFieldEnum;
import com.yandex.direct.api.v5.ads.TextAdBuilderAdFieldEnum;
import com.yandex.direct.api.v5.ads.TextAdFieldEnum;
import com.yandex.direct.api.v5.ads.TextAdPriceExtensionFieldEnum;
import com.yandex.direct.api.v5.ads.TextImageAdFieldEnum;

@ParametersAreNonnullByDefault
public enum AdAnyFieldEnum {

    AD_CATEGORIES(AdFieldEnum.class, AdFieldEnum.AD_CATEGORIES),
    AD_AGE_LABEL(AdFieldEnum.class, AdFieldEnum.AGE_LABEL),
    AD_ADGROUP_ID(AdFieldEnum.class, AdFieldEnum.AD_GROUP_ID),
    AD_CAMPAIGN_ID(AdFieldEnum.class, AdFieldEnum.CAMPAIGN_ID),
    AD_ID(AdFieldEnum.class, AdFieldEnum.ID),
    AD_STATE(AdFieldEnum.class, AdFieldEnum.STATE),
    AD_STATUS(AdFieldEnum.class, AdFieldEnum.STATUS),
    AD_STATUS_CLARIFICATION(AdFieldEnum.class, AdFieldEnum.STATUS_CLARIFICATION),
    AD_TYPE(AdFieldEnum.class, AdFieldEnum.TYPE),
    AD_SUBTYPE(AdFieldEnum.class, AdFieldEnum.SUBTYPE),

    TEXT_AD_IMAGE_HASH(TextAdFieldEnum.class, TextAdFieldEnum.AD_IMAGE_HASH),
    TEXT_AD_DISPLAY_DOMAIN(TextAdFieldEnum.class, TextAdFieldEnum.DISPLAY_DOMAIN),
    TEXT_AD_HREF(TextAdFieldEnum.class, TextAdFieldEnum.HREF),
    TEXT_AD_SITELINK_SET_ID(TextAdFieldEnum.class, TextAdFieldEnum.SITELINK_SET_ID),
    TEXT_AD_TEXT(TextAdFieldEnum.class, TextAdFieldEnum.TEXT),
    TEXT_AD_TITLE(TextAdFieldEnum.class, TextAdFieldEnum.TITLE),
    TEXT_AD_TITLE_2(TextAdFieldEnum.class, TextAdFieldEnum.TITLE_2),
    TEXT_AD_MOBILE(TextAdFieldEnum.class, TextAdFieldEnum.MOBILE),
    TEXT_AD_V_CARD_ID(TextAdFieldEnum.class, TextAdFieldEnum.V_CARD_ID),
    TEXT_AD_DISPLAY_URL_PATH(TextAdFieldEnum.class, TextAdFieldEnum.DISPLAY_URL_PATH),
    TEXT_AD_DUT_PREFIX(TextAdFieldEnum.class, TextAdFieldEnum.DUT_PREFIX),
    TEXT_AD_DUT_SUFFIX(TextAdFieldEnum.class, TextAdFieldEnum.DUT_SUFFIX),
    TEXT_AD_IMAGE_MODERATION(TextAdFieldEnum.class, TextAdFieldEnum.AD_IMAGE_MODERATION),
    TEXT_AD_SITELINKS_MODERATION(TextAdFieldEnum.class, TextAdFieldEnum.SITELINKS_MODERATION),
    TEXT_AD_V_CARD_MODERATION(TextAdFieldEnum.class, TextAdFieldEnum.V_CARD_MODERATION),
    TEXT_AD_EXTENSIONS(TextAdFieldEnum.class, TextAdFieldEnum.AD_EXTENSIONS),
    TEXT_AD_DISPLAY_URL_PATH_MODERATION(TextAdFieldEnum.class, TextAdFieldEnum.DISPLAY_URL_PATH_MODERATION),
    TEXT_AD_VIDEO_EXTENSION(TextAdFieldEnum.class, TextAdFieldEnum.VIDEO_EXTENSION),
    TEXT_AD_TURBO_PAGE_ID(TextAdFieldEnum.class, TextAdFieldEnum.TURBO_PAGE_ID),
    TEXT_AD_TURBO_PAGE_MODERATION(TextAdFieldEnum.class, TextAdFieldEnum.TURBO_PAGE_MODERATION),
    TEXT_AD_BUSINESS_ID(TextAdFieldEnum.class, TextAdFieldEnum.BUSINESS_ID),
    TEXT_AD_TRACKING_PHONE_ID(TextAdFieldEnum.class, TextAdFieldEnum.TRACKING_PHONE_ID),
    TEXT_AD_PREFER_V_CARD_OVER_BUSINESS(TextAdFieldEnum.class, TextAdFieldEnum.PREFER_V_CARD_OVER_BUSINESS),
    TEXT_AD_BUTTON_EXTENSION(TextAdFieldEnum.class, TextAdFieldEnum.BUTTON_EXTENSION),
    TEXT_AD_BUTTON_EXTENSION_MODERATION(TextAdFieldEnum.class, TextAdFieldEnum.BUTTON_EXTENSION_MODERATION),
    TEXT_AD_LOGO_IMAGE_HASH(TextAdFieldEnum.class, TextAdFieldEnum.LOGO_EXTENSION_HASH),
    TEXT_AD_LOGO_EXTENSION_MODERATION(TextAdFieldEnum.class, TextAdFieldEnum.LOGO_EXTENSION_MODERATION),
    TEXT_AD_LF_HREF(TextAdFieldEnum.class, TextAdFieldEnum.LF_HREF),
    TEXT_AD_LF_BUTTON_TEXT(TextAdFieldEnum.class, TextAdFieldEnum.LF_BUTTON_TEXT),

    MOBILE_APP_AD_IMAGE_HASH(MobileAppAdFieldEnum.class, MobileAppAdFieldEnum.AD_IMAGE_HASH),
    MOBILE_APP_AD_TITLE(MobileAppAdFieldEnum.class, MobileAppAdFieldEnum.TITLE),
    MOBILE_APP_AD_TEXT(MobileAppAdFieldEnum.class, MobileAppAdFieldEnum.TEXT),
    MOBILE_APP_AD_FEATURES(MobileAppAdFieldEnum.class, MobileAppAdFieldEnum.FEATURES),
    MOBILE_APP_AD_ACTION(MobileAppAdFieldEnum.class, MobileAppAdFieldEnum.ACTION),
    MOBILE_APP_AD_TRACKING_URL(MobileAppAdFieldEnum.class, MobileAppAdFieldEnum.TRACKING_URL),
    MOBILE_APP_AD_IMPRESSION_URL(MobileAppAdFieldEnum.class, MobileAppAdFieldEnum.IMPRESSION_URL),
    MOBILE_APP_AD_IMAGE_MODERATION(MobileAppAdFieldEnum.class, MobileAppAdFieldEnum.AD_IMAGE_MODERATION),
    MOBILE_APP_AD_VIDEO_EXTENSION(MobileAppAdFieldEnum.class, MobileAppAdFieldEnum.VIDEO_EXTENSION),

    DYNAMIC_TEXT_AD_IMAGE_HASH(DynamicTextAdFieldEnum.class, DynamicTextAdFieldEnum.AD_IMAGE_HASH),
    DYNAMIC_TEXT_AD_SITELINK_SET_ID(DynamicTextAdFieldEnum.class, DynamicTextAdFieldEnum.SITELINK_SET_ID),
    DYNAMIC_TEXT_AD_TEXT(DynamicTextAdFieldEnum.class, DynamicTextAdFieldEnum.TEXT),
    DYNAMIC_TEXT_AD_V_CARD_ID(DynamicTextAdFieldEnum.class, DynamicTextAdFieldEnum.V_CARD_ID),
    DYNAMIC_TEXT_AD_IMAGE_MODERATION(DynamicTextAdFieldEnum.class, DynamicTextAdFieldEnum.AD_IMAGE_MODERATION),
    DYNAMIC_TEXT_AD_SITELINKS_MODERATION(DynamicTextAdFieldEnum.class, DynamicTextAdFieldEnum.SITELINKS_MODERATION),
    DYNAMIC_TEXT_AD_V_CARD_MODERATION(DynamicTextAdFieldEnum.class, DynamicTextAdFieldEnum.V_CARD_MODERATION),
    DYNAMIC_TEXT_AD_EXTENSIONS(DynamicTextAdFieldEnum.class, DynamicTextAdFieldEnum.AD_EXTENSIONS),

    TEXT_IMAGE_AD_IMAGE_HASH(TextImageAdFieldEnum.class, TextImageAdFieldEnum.AD_IMAGE_HASH),
    TEXT_IMAGE_AD_HREF(TextImageAdFieldEnum.class, TextImageAdFieldEnum.HREF),
    TEXT_IMAGE_AD_TURBO_PAGE_ID(TextImageAdFieldEnum.class, TextImageAdFieldEnum.TURBO_PAGE_ID),
    TEXT_IMAGE_AD_TURBO_PAGE_MODERATION(TextImageAdFieldEnum.class, TextImageAdFieldEnum.TURBO_PAGE_MODERATION),
    TEXT_IMAGE_AD_BUTTON_EXTENSION(TextImageAdFieldEnum.class, TextImageAdFieldEnum.BUTTON_EXTENSION),
    TEXT_IMAGE_AD_EXTENSION_MODERATION(TextImageAdFieldEnum.class, TextImageAdFieldEnum.BUTTON_EXTENSION_MODERATION),
    TEXT_IMAGE_AD_LOGO_IMAGE_HASH(TextImageAdFieldEnum.class, TextImageAdFieldEnum.LOGO_EXTENSION_HASH),
    TEXT_IMAGE_AD_LOGO_MODERATION(TextImageAdFieldEnum.class, TextImageAdFieldEnum.LOGO_EXTENSION_MODERATION),


    TEXT_IMAGE_AD_TEXT(TextImageAdFieldEnum.class, TextImageAdFieldEnum.TEXT),
    TEXT_IMAGE_AD_TITLE(TextImageAdFieldEnum.class, TextImageAdFieldEnum.TITLE),
    TEXT_IMAGE_AD_TITLE_2(TextImageAdFieldEnum.class, TextImageAdFieldEnum.TITLE_2),

    MOBILE_APP_IMAGE_AD_IMAGE_HASH(MobileAppImageAdFieldEnum.class, MobileAppImageAdFieldEnum.AD_IMAGE_HASH),
    MOBILE_APP_IMAGE_AD_TRACKING_URL(MobileAppImageAdFieldEnum.class, MobileAppImageAdFieldEnum.TRACKING_URL),

    MOBILE_APP_CPC_VIDEO_AD_BUILDER_AD_CREATIVE(MobileAppCpcVideoAdBuilderAdFieldEnum.class,
            MobileAppCpcVideoAdBuilderAdFieldEnum.CREATIVE),
    MOBILE_APP_CPC_VIDEO_AD_BUILDER_AD_TRACKING_URL(MobileAppCpcVideoAdBuilderAdFieldEnum.class,
            MobileAppCpcVideoAdBuilderAdFieldEnum.TRACKING_URL),

    TEXT_AD_BUILDER_AD_CREATIVE(TextAdBuilderAdFieldEnum.class, TextAdBuilderAdFieldEnum.CREATIVE),
    TEXT_AD_BUILDER_AD_HREF(TextAdBuilderAdFieldEnum.class, TextAdBuilderAdFieldEnum.HREF),
    TEXT_AD_BUILDER_TURBO_PAGE_ID(TextAdBuilderAdFieldEnum.class, TextAdBuilderAdFieldEnum.TURBO_PAGE_ID),
    TEXT_AD_BUILDER_TURBO_PAGE_MODERATION(TextAdBuilderAdFieldEnum.class, TextAdBuilderAdFieldEnum.TURBO_PAGE_MODERATION),

    TEXT_AD_BUILDER_AD_BUTTON_EXTENSION(TextAdBuilderAdFieldEnum.class, TextAdBuilderAdFieldEnum.BUTTON_EXTENSION),
    TEXT_AD_BUILDER_AD_EXTENSION_MODERATION(TextAdBuilderAdFieldEnum.class, TextAdBuilderAdFieldEnum.BUTTON_EXTENSION_MODERATION),
    TEXT_AD_BUILDER_AD_LOGO_IMAGE_HASH(TextAdBuilderAdFieldEnum.class, TextAdBuilderAdFieldEnum.LOGO_EXTENSION_HASH),
    TEXT_AD_BUILDER_AD_LOGO_MODERATION(TextAdBuilderAdFieldEnum.class, TextAdBuilderAdFieldEnum.LOGO_EXTENSION_MODERATION),



    TEXT_AD_BUILDER_AD_TEXT(TextAdBuilderAdFieldEnum.class, TextAdBuilderAdFieldEnum.TEXT),
    TEXT_AD_BUILDER_AD_TITLE(TextAdBuilderAdFieldEnum.class, TextAdBuilderAdFieldEnum.TITLE),
    TEXT_AD_BUILDER_AD_TITLE_2(TextAdBuilderAdFieldEnum.class, TextAdBuilderAdFieldEnum.TITLE_2),

    MOBILE_APP_AD_BUILDER_AD_CREATIVE(MobileAppAdBuilderAdFieldEnum.class, MobileAppAdBuilderAdFieldEnum.CREATIVE),
    MOBILE_APP_AD_BUILDER_AD_TRACKING_URL(MobileAppAdBuilderAdFieldEnum.class,
            MobileAppAdBuilderAdFieldEnum.TRACKING_URL),

    CPM_BANNER_AD_BUILDER_AD_CREATIVE(CpmBannerAdBuilderAdFieldEnum.class, CpmBannerAdBuilderAdFieldEnum.CREATIVE),
    CPM_BANNER_AD_BUILDER_AD_HREF(CpmBannerAdBuilderAdFieldEnum.class, CpmBannerAdBuilderAdFieldEnum.HREF),
    CPM_BANNER_AD_BUILDER_AD_TRACKING_PIXELS(CpmBannerAdBuilderAdFieldEnum.class,
            CpmBannerAdBuilderAdFieldEnum.TRACKING_PIXELS),
    CPM_BANNER_AD_BUILDER_AD_TURBO_PAGE_ID(CpmBannerAdBuilderAdFieldEnum.class, CpmBannerAdBuilderAdFieldEnum.TURBO_PAGE_ID),
    CPM_BANNER_AD_BUILDER_AD_TURBO_PAGE_MODERATION(CpmBannerAdBuilderAdFieldEnum.class, CpmBannerAdBuilderAdFieldEnum.TURBO_PAGE_MODERATION),
    CPM_BANNER_AD_BUILDER_AD_TNS_ID(CpmBannerAdBuilderAdFieldEnum.class, CpmBannerAdBuilderAdFieldEnum.TNS_ID),

    CPC_VIDEO_AD_BUILDER_AD_HREF(CpcVideoAdBuilderAdFieldEnum.class, CpcVideoAdBuilderAdFieldEnum.HREF),
    CPC_VIDEO_AD_BUILDER_AD_CREATIVE(CpcVideoAdBuilderAdFieldEnum.class, CpcVideoAdBuilderAdFieldEnum.CREATIVE),
    CPC_VIDEO_AD_BUILDER_AD_TURBO_PAGE_ID(CpcVideoAdBuilderAdFieldEnum.class, CpcVideoAdBuilderAdFieldEnum.TURBO_PAGE_ID),
    CPC_VIDEO_AD_BUILDER_AD_TURBO_PAGE_MODERATION(CpcVideoAdBuilderAdFieldEnum.class, CpcVideoAdBuilderAdFieldEnum.TURBO_PAGE_MODERATION),

    CPM_VIDEO_AD_BUILDER_AD_HREF(CpmVideoAdBuilderAdFieldEnum.class, CpmVideoAdBuilderAdFieldEnum.HREF),
    CPM_VIDEO_AD_BUILDER_AD_CREATIVE(CpmVideoAdBuilderAdFieldEnum.class, CpmVideoAdBuilderAdFieldEnum.CREATIVE),
    CPM_VIDEO_AD_BUILDER_AD_TRACKING_PIXELS(CpmVideoAdBuilderAdFieldEnum.class,
            CpmVideoAdBuilderAdFieldEnum.TRACKING_PIXELS),
    CPM_VIDEO_AD_BUILDER_AD_TURBO_PAGE_ID(CpmVideoAdBuilderAdFieldEnum.class, CpmVideoAdBuilderAdFieldEnum.TURBO_PAGE_ID),
    CPM_VIDEO_AD_BUILDER_AD_TURBO_PAGE_MODERATION(CpmVideoAdBuilderAdFieldEnum.class, CpmVideoAdBuilderAdFieldEnum.TURBO_PAGE_MODERATION),
    CPM_VIDEO_AD_BUILDER_AD_TNS_ID(CpmVideoAdBuilderAdFieldEnum.class, CpmVideoAdBuilderAdFieldEnum.TNS_ID),
    CPM_VIDEO_AD_BUILDER_AD_LOGO_IMAGE_HASH(CpmVideoAdBuilderAdFieldEnum.class, CpmVideoAdBuilderAdFieldEnum.LOGO_EXTENSION_HASH),
    CPM_VIDEO_AD_LOGO_MODERATION(CpmVideoAdBuilderAdFieldEnum.class, CpmVideoAdBuilderAdFieldEnum.LOGO_EXTENSION_MODERATION),

    CPM_VIDEO_AD_BUILDER_AD_BUTTON_EXTENSION(CpmVideoAdBuilderAdFieldEnum.class, CpmVideoAdBuilderAdFieldEnum.BUTTON_EXTENSION),
    CPM_VIDEO_AD_BUILDER_AD_BUTTON_EXTENSION_MODERATION(CpmVideoAdBuilderAdFieldEnum.class, CpmVideoAdBuilderAdFieldEnum.BUTTON_EXTENSION_MODERATION),
    CPM_VIDEO_AD_BUILDER_AD_TEXT(CpmVideoAdBuilderAdFieldEnum.class, CpmVideoAdBuilderAdFieldEnum.TEXT),
    CPM_VIDEO_AD_BUILDER_AD_TITLE(CpmVideoAdBuilderAdFieldEnum.class, CpmVideoAdBuilderAdFieldEnum.TITLE),
    CPM_VIDEO_AD_BUILDER_AD_TITLE_2(CpmVideoAdBuilderAdFieldEnum.class, CpmVideoAdBuilderAdFieldEnum.TITLE_2),

    SMART_AD_BUILDER_AD_CREATIVE(SmartAdBuilderAdFieldEnum.class, SmartAdBuilderAdFieldEnum.CREATIVE),
    SMART_AD_BUILDER_AD_LOGO_IMAGE_HASH(SmartAdBuilderAdFieldEnum.class, SmartAdBuilderAdFieldEnum.LOGO_EXTENSION_HASH),
    SMART_AD_BUILDER_AD_LOGO_MODERATION(SmartAdBuilderAdFieldEnum.class, SmartAdBuilderAdFieldEnum.LOGO_EXTENSION_MODERATION),

    CONTENT_PROMOTION_VIDEO_AD_CONTENT_ID(ContentPromotionVideoAdFieldEnum.class,
            ContentPromotionVideoAdFieldEnum.PROMOTED_CONTENT_ID),
    CONTENT_PROMOTION_VIDEO_AD_HREF(ContentPromotionVideoAdFieldEnum.class,
            ContentPromotionVideoAdFieldEnum.VISIT_HREF),
    CONTENT_PROMOTION_VIDEO_AD_BODY(ContentPromotionVideoAdFieldEnum.class,
            ContentPromotionVideoAdFieldEnum.TEXT),
    CONTENT_PROMOTION_VIDEO_AD_TITLE(ContentPromotionVideoAdFieldEnum.class,
            ContentPromotionVideoAdFieldEnum.TITLE),

    CONTENT_PROMOTION_COLLECTION_AD_CONTENT_ID(ContentPromotionCollectionAdFieldEnum.class,
            ContentPromotionCollectionAdFieldEnum.PROMOTED_CONTENT_ID),
    CONTENT_PROMOTION_COLLECTION_AD_HREF(ContentPromotionCollectionAdFieldEnum.class,
            ContentPromotionCollectionAdFieldEnum.VISIT_HREF),

    CONTENT_PROMOTION_SERVICE_AD_CONTENT_ID(ContentPromotionServiceAdFieldEnum.class,
            ContentPromotionServiceAdFieldEnum.PROMOTED_CONTENT_ID),
    CONTENT_PROMOTION_SERVICE_AD_TITLE(ContentPromotionServiceAdFieldEnum.class,
            ContentPromotionServiceAdFieldEnum.TITLE),

    CONTENT_PROMOTION_EDA_AD_CONTENT_ID(ContentPromotionEdaAdFieldEnum.class,
            ContentPromotionEdaAdFieldEnum.PROMOTED_CONTENT_ID),
    CONTENT_PROMOTION_EDA_AD_BODY(ContentPromotionEdaAdFieldEnum.class,
            ContentPromotionEdaAdFieldEnum.TEXT),
    CONTENT_PROMOTION_EDA_AD_TITLE(ContentPromotionEdaAdFieldEnum.class,
            ContentPromotionEdaAdFieldEnum.TITLE),

    PRICE_EXTENSION_PRICE(TextAdPriceExtensionFieldEnum.class, TextAdPriceExtensionFieldEnum.PRICE),
    PRICE_EXTENSION_OLD_PRICE(TextAdPriceExtensionFieldEnum.class, TextAdPriceExtensionFieldEnum.OLD_PRICE),
    PRICE_EXTENSION_PRICE_CURRENCY(TextAdPriceExtensionFieldEnum.class, TextAdPriceExtensionFieldEnum.PRICE_CURRENCY),
    PRICE_EXTENSION_PRICE_QUALIFIER(TextAdPriceExtensionFieldEnum.class, TextAdPriceExtensionFieldEnum.PRICE_QUALIFIER);

    private final Class<?> enumClass;
    private final Enum value;

    AdAnyFieldEnum(Class<?> enumClass, Enum value) {
        this.enumClass = enumClass;
        this.value = value;
    }

    public static AdAnyFieldEnum fromAdFieldEnum(AdFieldEnum adFieldEnum) {
        return Arrays.stream(AdAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(AdFieldEnum.class) && v.getValue().equals(adFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static AdAnyFieldEnum fromTextAdFieldEnum(TextAdFieldEnum textAdFieldEnum) {
        return Arrays.stream(AdAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(TextAdFieldEnum.class) && v.getValue().equals(textAdFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static AdAnyFieldEnum fromTextAdPriceExtensionFieldEnum(
            TextAdPriceExtensionFieldEnum textAdPriceExtensionFieldEnum) {
        return Arrays.stream(AdAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(TextAdPriceExtensionFieldEnum.class)
                        && v.getValue().equals(textAdPriceExtensionFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static AdAnyFieldEnum fromMobileAppAdFieldEnum(MobileAppAdFieldEnum mobileAppAdFieldEnum) {
        return Arrays.stream(AdAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(MobileAppAdFieldEnum.class) && v.getValue()
                        .equals(mobileAppAdFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static AdAnyFieldEnum fromDynamicTextAdFieldEnum(DynamicTextAdFieldEnum dynamicTextAdFieldEnum) {
        return Arrays.stream(AdAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(DynamicTextAdFieldEnum.class) && v.getValue()
                        .equals(dynamicTextAdFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static AdAnyFieldEnum fromTextImageAdFieldEnum(TextImageAdFieldEnum textImageAdFieldEnum) {
        return Arrays.stream(AdAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(TextImageAdFieldEnum.class) && v.getValue()
                        .equals(textImageAdFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static AdAnyFieldEnum fromMobileAppImageAdFieldEnum(MobileAppImageAdFieldEnum mobileAppImageAdFieldEnum) {
        return Arrays.stream(AdAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(MobileAppImageAdFieldEnum.class) && v.getValue()
                        .equals(mobileAppImageAdFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static AdAnyFieldEnum fromMobileAppCpcVideoAdBuilderAdFieldEnum(
            MobileAppCpcVideoAdBuilderAdFieldEnum mobileAppCpcVideoAdBuilderAdFieldEnum) {
        return Arrays.stream(AdAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(MobileAppCpcVideoAdBuilderAdFieldEnum.class)
                        && v.getValue().equals(mobileAppCpcVideoAdBuilderAdFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static AdAnyFieldEnum fromTextAdBuilderAdFieldEnum(TextAdBuilderAdFieldEnum textAdBuilderAdFieldEnum) {
        return Arrays.stream(AdAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(TextAdBuilderAdFieldEnum.class) && v.getValue()
                        .equals(textAdBuilderAdFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static AdAnyFieldEnum fromMobileAppAdBuilderAdFieldEnum(
            MobileAppAdBuilderAdFieldEnum mobileAppAdBuilderAdFieldEnum) {
        return Arrays.stream(AdAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(MobileAppAdBuilderAdFieldEnum.class) && v.getValue()
                        .equals(mobileAppAdBuilderAdFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static AdAnyFieldEnum fromCpmBannerAdBuilderAdFieldEnum(
            CpmBannerAdBuilderAdFieldEnum cpmBannerAdBuilderAdFieldEnum) {
        return Arrays.stream(AdAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(CpmBannerAdBuilderAdFieldEnum.class) && v.getValue()
                        .equals(cpmBannerAdBuilderAdFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static AdAnyFieldEnum fromCpcVideoAdBuilderAdFieldEnum(
            CpcVideoAdBuilderAdFieldEnum cpcVideoAdBuilderAdFieldEnum) {
        return Arrays.stream(AdAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(CpcVideoAdBuilderAdFieldEnum.class) && v.getValue()
                        .equals(cpcVideoAdBuilderAdFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static AdAnyFieldEnum fromCpmVideoAdBuilderAdFieldEnum(
            CpmVideoAdBuilderAdFieldEnum cpmVideoAdBuilderAdFieldEnum) {
        return Arrays.stream(AdAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(CpmVideoAdBuilderAdFieldEnum.class) && v.getValue()
                        .equals(cpmVideoAdBuilderAdFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static AdAnyFieldEnum fromSmartAdBuilderAdFieldEnum(
            SmartAdBuilderAdFieldEnum smartAdBuilderAdFieldEnum) {
        return Arrays.stream(AdAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(SmartAdBuilderAdFieldEnum.class) && v.getValue()
                        .equals(smartAdBuilderAdFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static AdAnyFieldEnum fromContentPromotionVideoAdFieldEnum(
            ContentPromotionVideoAdFieldEnum contentPromotionVideoAdFieldEnum) {
        return Arrays.stream(AdAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(ContentPromotionVideoAdFieldEnum.class) && v.getValue()
                        .equals(contentPromotionVideoAdFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static AdAnyFieldEnum fromContentPromotionCollectionAdFieldEnum(
            ContentPromotionCollectionAdFieldEnum contentPromotionCollectionAdFieldEnum) {
        return Arrays.stream(AdAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(ContentPromotionCollectionAdFieldEnum.class) && v.getValue()
                        .equals(contentPromotionCollectionAdFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static AdAnyFieldEnum fromContentPromotionServiceAdFieldEnum(
            ContentPromotionServiceAdFieldEnum contentPromotionServiceAdFieldEnum) {
        return Arrays.stream(AdAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(ContentPromotionServiceAdFieldEnum.class) && v.getValue()
                        .equals(contentPromotionServiceAdFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static AdAnyFieldEnum fromContentPromotionEdaAdFieldEnum(
            ContentPromotionEdaAdFieldEnum fromContentPromotionEdaAdFieldEnum) {
        return Arrays.stream(AdAnyFieldEnum.values())
                .filter(v -> v.getEnumClass().equals(ContentPromotionEdaAdFieldEnum.class) && v.getValue()
                        .equals(fromContentPromotionEdaAdFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public Class<?> getEnumClass() {
        return enumClass;
    }

    public Enum getValue() {
        return value;
    }
}
