package ru.yandex.direct.api.v5.entity.ads.delegate;

import java.util.List;
import java.util.Set;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.ads.ModerateRequest;
import com.yandex.direct.api.v5.ads.ModerateResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.converter.ResultConverter;
import ru.yandex.direct.api.v5.entity.OperationOnListDelegate;
import ru.yandex.direct.api.v5.entity.ads.validation.AdsModerateRequestValidator;
import ru.yandex.direct.api.v5.result.ApiMassResult;
import ru.yandex.direct.api.v5.result.ApiResult;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.common.db.PpcPropertiesSupport;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.banner.service.moderation.BannerModerateService;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class ModerateAdsDelegate
        extends OperationOnListDelegate<ModerateRequest, ModerateResponse, Long, Long> {
    private static final Logger logger = LoggerFactory.getLogger(ModerateAdsDelegate.class);

    private final BannerModerateService bannerModerateService;
    private final AdsModerateRequestValidator validatior;
    private final ResultConverter resultConverter;

    public ModerateAdsDelegate(ApiAuthenticationSource authentication,
                               BannerModerateService bannerModerateService,
                               AdsModerateRequestValidator validatior,
                               ResultConverter resultConverter,
                               PpcPropertiesSupport ppcPropertiesSupport,
                               FeatureService featureService) {
        super(ApiPathConverter.forAds(), authentication, ppcPropertiesSupport, featureService);
        this.bannerModerateService = bannerModerateService;
        this.validatior = validatior;
        this.resultConverter = resultConverter;
    }

    @Nullable
    @Override
    public ValidationResult<ModerateRequest, DefectType> validateRequest(ModerateRequest externalRequest) {
        return validatior.validate(externalRequest);
    }

    @Override
    public List<Long> convertRequest(ModerateRequest externalRequest) {
        return externalRequest.getSelectionCriteria().getIds();
    }

    @Nonnull
    @Override
    public ValidationResult<List<Long>, DefectType> validateInternalRequest(List<Long> internalRequest) {
        ClientId clientId = auth.getChiefSubclient().getClientId();
        Set<AdGroupType> allowedAdGroupTypes = getAllowedAdGroupTypes();
        return validatior.validateInternalRequest(clientId, internalRequest, allowedAdGroupTypes);
    }

    @Override
    public ApiMassResult<Long> processList(List<Long> validItems) {
        MassResult<Long> result = bannerModerateService.moderateBanners(getClientId(), getOperatorUid(), validItems);
        return resultConverter.toApiMassResult(result);
    }

    @Override
    public ModerateResponse convertResponse(ApiResult<List<ApiResult<Long>>> result) {
        logger.debug("convert result: {}", result);
        return new ModerateResponse().withModerateResults(resultConverter.toActionResults(result, apiPathConverter));
    }

    private ClientId getClientId() {
        return auth.getChiefSubclient().getClientId();
    }

    private Long getOperatorUid() {
        return auth.getOperator().getUid();
    }
}
