package ru.yandex.direct.api.v5.entity.ads.validation;

import java.util.LinkedHashSet;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.kscs.util.jaxb.SinglePropertyInfo;
import com.yandex.direct.api.v5.ads.AdAddItem;
import one.util.streamex.StreamEx;

import static org.apache.commons.lang3.StringUtils.capitalize;

@ParametersAreNonnullByDefault
public class AdTypeNames {
    private AdTypeNames() {
        // no instantiation
    }

    private static final String API5_ALLOWED_AD_TYPES;

    static {
        // Порядок типов важен! На него завязаны тесты в aqua.
        Set<SinglePropertyInfo> types = new LinkedHashSet<>();
        types.add(AdAddItem.PropInfo.TEXT_AD);
        types.add(AdAddItem.PropInfo.DYNAMIC_TEXT_AD);
        types.add(AdAddItem.PropInfo.MOBILE_APP_AD);
        types.add(AdAddItem.PropInfo.TEXT_IMAGE_AD);
        types.add(AdAddItem.PropInfo.MOBILE_APP_IMAGE_AD);
        types.add(AdAddItem.PropInfo.TEXT_AD_BUILDER_AD);
        types.add(AdAddItem.PropInfo.MOBILE_APP_AD_BUILDER_AD);
        types.add(AdAddItem.PropInfo.CPM_BANNER_AD_BUILDER_AD);
        types.add(AdAddItem.PropInfo.CPC_VIDEO_AD_BUILDER_AD);
        types.add(AdAddItem.PropInfo.CPM_VIDEO_AD_BUILDER_AD);
        types.add(AdAddItem.PropInfo.CONTENT_PROMOTION_VIDEO_AD);
        types.add(AdAddItem.PropInfo.CONTENT_PROMOTION_COLLECTION_AD);
        types.add(AdAddItem.PropInfo.CONTENT_PROMOTION_SERVICE_AD);
        types.add(AdAddItem.PropInfo.CONTENT_PROMOTION_EDA_AD);
        types.add(AdAddItem.PropInfo.SMART_AD_BUILDER_AD);
        types.add(AdAddItem.PropInfo.MOBILE_APP_CPC_VIDEO_AD_BUILDER_AD);

        API5_ALLOWED_AD_TYPES = joinProperties(types);
    }

    private static String joinProperties(Set<SinglePropertyInfo> types) {
        return StreamEx.of(types).map(pi -> capitalize(pi.propertyName)).joining(", ");
    }

    public static String getApi5AllowedAdTypes() {
        return API5_ALLOWED_AD_TYPES;
    }
}
