package ru.yandex.direct.api.v5.entity.advideos;

import ru.yandex.direct.api.v5.common.validation.DefaultApiPresentations;
import ru.yandex.direct.api.v5.common.validation.DefectPresentationsHolder;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.core.entity.creative.service.add.validation.CreativeDefectIds;

import static ru.yandex.direct.api.v5.validation.DefectTypes.invalidValue;

public class AdVideosDefectTypes {
    public static final DefectPresentationsHolder DEFECT_PRESENTATIONS = DefectPresentationsHolder
            .builderWithFallback(DefaultApiPresentations.HOLDER)
            .register(CreativeDefectIds.Gen.UPLOAD_VIDEO_FAILED, uploadVideoFromUrlFailed())
            .build();

    private static AdVideosDefectTranslations translations() {
        return AdVideosDefectTranslations.INSTANCE;
    }

    public static DefectType uploadVideoFromUrlFailed() {
        return invalidValue()
                .withDetailedMessage(translations().uploadVideoFromUrlFailed());
    }
}
