package ru.yandex.direct.api.v5.entity.advideos;

import com.yandex.direct.api.v5.advideos.AdVideosPort;
import com.yandex.direct.api.v5.advideos.AddRequest;
import com.yandex.direct.api.v5.advideos.AddResponse;
import com.yandex.direct.api.v5.advideos.ApiException;
import com.yandex.direct.api.v5.advideos.GetRequest;
import com.yandex.direct.api.v5.advideos.GetResponse;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.advideos.delegate.AddAdVideosDelegate;
import ru.yandex.direct.api.v5.entity.advideos.delegate.GetAdVideosDelegate;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;

@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.CLIENT)
public class AsVideosEndpoint implements AdVideosPort {
    private static final String SERVICE_NAME = "advideos";

    private final GenericApiService genericApiService;
    private final AddAdVideosDelegate addAdVideosDelegate;
    private final GetAdVideosDelegate getAdVideosDelegate;

    @Autowired
    public AsVideosEndpoint(GenericApiService genericApiService,
                            AddAdVideosDelegate addAdVideosDelegate,
                            GetAdVideosDelegate getAdVideosDelegate) {
        this.genericApiService = genericApiService;
        this.addAdVideosDelegate = addAdVideosDelegate;
        this.getAdVideosDelegate = getAdVideosDelegate;
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "add")
    @ApiResponse
    @Override
    public AddResponse add(@ApiRequest AddRequest parameters) throws ApiException {
        return genericApiService.doAction(addAdVideosDelegate, parameters);
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest parameters) throws ApiException {
        return genericApiService.doAction(getAdVideosDelegate, parameters);
    }
}
