package ru.yandex.direct.api.v5.entity.advideos.delegate;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.advideos.AddRequest;
import com.yandex.direct.api.v5.advideos.AddResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.converter.ResultConverter;
import ru.yandex.direct.api.v5.entity.OperationOnListDelegate;
import ru.yandex.direct.api.v5.entity.advideos.converter.AdVideosHelperConverter;
import ru.yandex.direct.api.v5.entity.advideos.validation.AddAdVideosValidationService;
import ru.yandex.direct.api.v5.result.ApiMassResult;
import ru.yandex.direct.api.v5.result.ApiResult;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.core.entity.creative.service.CreativeService;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.api.v5.entity.advideos.AdVideosDefectTypes.DEFECT_PRESENTATIONS;

@Service
@ParametersAreNonnullByDefault
public class AddAdVideosDelegate
        extends OperationOnListDelegate<AddRequest, AddResponse, CreativeService.VideoItemForUpload, CreativeService.VideoItem> {
    private final AddAdVideosValidationService validationService;
    private final ResultConverter resultConverter;
    private final CreativeService creativeService;
    private final AdVideosHelperConverter adVideosHelperConverter;

    @Autowired
    public AddAdVideosDelegate(
            ApiAuthenticationSource auth,
            AddAdVideosValidationService validationService,
            ResultConverter resultConverter,
            AdVideosHelperConverter adVideosHelperConverter,
            CreativeService creativeService) {
        super(ApiPathConverter.forAdVideos(), auth);
        this.validationService = validationService;
        this.resultConverter = resultConverter;
        this.adVideosHelperConverter = adVideosHelperConverter;
        this.creativeService = creativeService;
    }

    @Nullable
    @Override
    public ValidationResult<AddRequest, DefectType> validateRequest(AddRequest addRequest) {
        return validationService.validateRequest(addRequest);
    }

    @Override
    public List<CreativeService.VideoItemForUpload> convertRequest(AddRequest addRequest) {
        return adVideosHelperConverter.convertAddRequest(addRequest);
    }

    @Override
    public ApiMassResult<CreativeService.VideoItem> processList(List<CreativeService.VideoItemForUpload> validItems) {
        var clientId = auth.getChiefSubclient().getClientId();
        MassResult<CreativeService.VideoItem> result = creativeService.createVideosForUpload(clientId, validItems);
        return resultConverter.toApiMassResult(result, DEFECT_PRESENTATIONS);
    }

    @Override
    public AddResponse convertResponse(ApiResult<List<ApiResult<CreativeService.VideoItem>>> result) {
        return adVideosHelperConverter.convertAddResponse(result, apiPathConverter);
    }
}
