package ru.yandex.direct.api.v5.entity.advideos.delegate;

import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.advideos.AdVideoFieldEnum;
import com.yandex.direct.api.v5.advideos.AdVideosSelectionCriteria;
import com.yandex.direct.api.v5.advideos.GetRequest;
import com.yandex.direct.api.v5.advideos.GetResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.api.v5.common.ApiPathConverter;
import ru.yandex.direct.api.v5.entity.GenericGetRequest;
import ru.yandex.direct.api.v5.entity.GetApiServiceDelegate;
import ru.yandex.direct.api.v5.entity.advideos.converter.AdVideosHelperConverter;
import ru.yandex.direct.api.v5.entity.advideos.validation.GetAdVideosValidationService;
import ru.yandex.direct.api.v5.security.ApiAuthenticationSource;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.core.entity.creative.service.CreativeService;
import ru.yandex.direct.validation.result.ValidationResult;

@Service
@ParametersAreNonnullByDefault
public class GetAdVideosDelegate
        extends GetApiServiceDelegate<GetRequest, GetResponse,
        AdVideoFieldEnum, AdVideosSelectionCriteria, CreativeService.VideoItemWithStatus> {
    private final GetAdVideosValidationService validationService;
    private final CreativeService creativeService;
    private final AdVideosHelperConverter adVideosHelperConverter;

    @Autowired
    public GetAdVideosDelegate(
            ApiAuthenticationSource auth,
            GetAdVideosValidationService validationService,
            AdVideosHelperConverter adVideosHelperConverter,
            CreativeService creativeService) {
        super(ApiPathConverter.forAdVideos(), auth);
        this.validationService = validationService;
        this.adVideosHelperConverter = adVideosHelperConverter;
        this.creativeService = creativeService;
    }

    @Nullable
    @Override
    public ValidationResult<GetRequest, DefectType> validateRequest(GetRequest getRequest) {
        return validationService.validateRequest(getRequest);
    }

    @Override
    public Set<AdVideoFieldEnum> extractFieldNames(GetRequest getRequest) {
        return adVideosHelperConverter.getAdVideoFieldEnums(getRequest);
    }

    @Override
    public AdVideosSelectionCriteria extractSelectionCriteria(GetRequest getRequest) {
        return getRequest.getSelectionCriteria();
    }

    @Override
    public List<CreativeService.VideoItemWithStatus> get(
            GenericGetRequest<AdVideoFieldEnum, AdVideosSelectionCriteria> getRequest) {
        var clientId = auth.getChiefSubclient().getClientId();

        List<CreativeService.VideoItem> internalRequest =
                adVideosHelperConverter.convertGetSelectionCriteria(getRequest.getSelectionCriteria());
        return creativeService.getVideoStatuses(clientId, internalRequest);
    }

    @Override
    public GetResponse convertGetResponse(List<CreativeService.VideoItemWithStatus> adVideos,
                                          Set<AdVideoFieldEnum> requestedFields,
                                          @Nullable Long limitedBy) {
        return adVideosHelperConverter.convertGetResponse(adVideos, requestedFields, limitedBy);
    }
}
