package ru.yandex.direct.api.v5.entity.advideos.validation;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.advideos.AdVideoAddItem;
import com.yandex.direct.api.v5.advideos.AddRequest;
import org.springframework.stereotype.Service;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.api.v5.validation.DefectTypes.maxElementsPerRequest;
import static ru.yandex.direct.api.v5.validation.constraints.Constraints.maxListSize;
import static ru.yandex.direct.api.v5.validation.constraints.Constraints.notNull;

@Service
@ParametersAreNonnullByDefault
public class AddAdVideosValidationService {
    public static final int MAX_ELEMENTS_PER_ADD_BY_URL = 10;
    public static final int MAX_ELEMENTS_PER_ADD_BY_FILE = 1;

    public ValidationResult<AddRequest, DefectType> validateRequest(AddRequest addRequest) {
        ItemValidationBuilder<AddRequest, DefectType> vb = ItemValidationBuilder.of(addRequest);

        ListValidationBuilder<AdVideoAddItem, DefectType> lvb =
                vb.list(addRequest.getAdVideos(), AddRequest.PropInfo.AD_VIDEOS.propertyName);
        int elementsLimit = addRequest.getAdVideos().stream().anyMatch(v -> v != null && v.getVideoData() != null) ?
                MAX_ELEMENTS_PER_ADD_BY_FILE :
                MAX_ELEMENTS_PER_ADD_BY_URL;
        lvb.checkEach(notNull())
                .check(maxListSize(elementsLimit), maxElementsPerRequest(elementsLimit))
                .checkEachBy(this.validateAddItem(), When.notNull());
        return vb.getResult();
    }

    private Validator<AdVideoAddItem, DefectType> validateAddItem() {
        return addItem -> {
            ItemValidationBuilder<AdVideoAddItem, DefectType> v = ItemValidationBuilder.of(addItem);
            if (addItem.getVideoData() != null) {
                v.item(addItem.getName(), AdVideoAddItem.PropInfo.NAME.propertyName)
                        .check(notNull());
            } else {
                v.item(addItem.getUrl(), AdVideoAddItem.PropInfo.URL.propertyName)
                        .check(notNull());
            }

            return v.getResult();
        };
    }
}
