package ru.yandex.direct.api.v5.entity.advideos.validation;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.advideos.AdVideosSelectionCriteria;
import com.yandex.direct.api.v5.advideos.GetRequest;
import org.springframework.stereotype.Service;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.api.v5.validation.DefectTypes.maxElementsInSelection;
import static ru.yandex.direct.api.v5.validation.constraints.Constraints.eachNotNull;
import static ru.yandex.direct.api.v5.validation.constraints.Constraints.maxListSize;

@Service
@ParametersAreNonnullByDefault
public class GetAdVideosValidationService {
    public static final int MAX_ELEMENTS_PER_GET = 10;

    public ValidationResult<GetRequest, DefectType> validateRequest(GetRequest getRequest) {
        ItemValidationBuilder<GetRequest, DefectType> vb = ItemValidationBuilder.of(getRequest);

        vb.item(getRequest.getSelectionCriteria(), GetRequest.PropInfo.SELECTION_CRITERIA.propertyName)
                .checkBy(validateSelectionCriteria(), When.notNull());

        return vb.getResult();
    }

    private static Validator<AdVideosSelectionCriteria, DefectType> validateSelectionCriteria() {
        return getItem -> {
            ItemValidationBuilder<AdVideosSelectionCriteria, DefectType> v = ItemValidationBuilder.of(getItem);
            v.list(getItem.getIds(), AdVideosSelectionCriteria.PropInfo.IDS.propertyName)
                    .check(eachNotNull())
                    .check(maxListSize(MAX_ELEMENTS_PER_GET), maxElementsInSelection(MAX_ELEMENTS_PER_GET));

            return v.getResult();
        };
    }
}
