package ru.yandex.direct.api.v5.entity.agencyclients;

import com.yandex.direct.api.v5.agencyclients.AddRequest;
import com.yandex.direct.api.v5.agencyclients.AddResponse;
import com.yandex.direct.api.v5.agencyclients.AgencyClientsPort;
import com.yandex.direct.api.v5.agencyclients.ApiException;
import com.yandex.direct.api.v5.agencyclients.GetRequest;
import com.yandex.direct.api.v5.agencyclients.GetResponse;
import com.yandex.direct.api.v5.agencyclients.UpdateRequest;
import com.yandex.direct.api.v5.agencyclients.UpdateResponse;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.agencyclients.delegate.AddAgencyClientsDelegate;
import ru.yandex.direct.api.v5.entity.agencyclients.delegate.GetAgencyClientsDelegate;
import ru.yandex.direct.api.v5.entity.agencyclients.delegate.UpdateAgencyClientDelegate;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeAgencyRead;

@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.AGENCY)
public class AgencyClientsEndpoint implements AgencyClientsPort {
    private static final String SERVICE_NAME = "agencyclients";

    private final GetAgencyClientsDelegate getAgencyClientsDelegate;
    private final AddAgencyClientsDelegate addAgencyClientsDelegate;
    private final GenericApiService genericApiService;
    private final UpdateAgencyClientDelegate updateAgencyClientDelegate;


    @Autowired
    public AgencyClientsEndpoint(
            GetAgencyClientsDelegate getAgencyClientsDelegate, AddAgencyClientsDelegate addAgencyClientsDelegate,
            GenericApiService genericApiService, UpdateAgencyClientDelegate updateAgencyClientDelegate) {
        this.getAgencyClientsDelegate = getAgencyClientsDelegate;
        this.addAgencyClientsDelegate = addAgencyClientsDelegate;
        this.genericApiService = genericApiService;
        this.updateAgencyClientDelegate = updateAgencyClientDelegate;
    }

    @PreAuthorizeAgencyRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest getRequest) throws ApiException {
        return genericApiService.doAction(getAgencyClientsDelegate, getRequest);
    }

    @PreAuthorizeAgencyRead
    // Аннотация нужна только для теста PreAuthorizeApiMethodTest.apiMethodsMustBeAnnotatedWithPreAuthorize
    @ApiMethod(service = SERVICE_NAME, operation = "add")
    @ApiResponse
    @Override
    public AddResponse add(@ApiRequest AddRequest addRequest) throws ApiException {
        return genericApiService.doAction(addAgencyClientsDelegate, addRequest);
    }

    @PreAuthorizeAgencyRead
    @ApiMethod(service = SERVICE_NAME, operation = "update")
    @ApiResponse
    @Override
    public UpdateResponse update(@ApiRequest UpdateRequest updateRequest) throws ApiException {
        return genericApiService.doAction(updateAgencyClientDelegate, updateRequest);
    }
}
