package ru.yandex.direct.api.v5.entity.agencyclients.service;

import java.util.Set;
import java.util.function.BiConsumer;

import com.yandex.direct.api.v5.generalclients.ClientGetItem;

import ru.yandex.direct.core.entity.user.model.User;

@FunctionalInterface
public interface ClientGetItemWriter {
    void write(Set<RequestedField> fieldNames, ClientGetItem getItem, User user);

    static ClientGetItemWriter forField(RequestedField fieldName, BiConsumer<ClientGetItem, User> writer) {
        return (fieldNames, getItem, user) -> {
            if (!fieldNames.contains(fieldName)) {
                return;
            }
            writer.accept(getItem, user);
        };
    }
}
