package ru.yandex.direct.api.v5.entity.agencyclients.service;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.client.model.Client;
import ru.yandex.direct.core.entity.grants.model.Grants;
import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.model.ModelChanges;

@ParametersAreNonnullByDefault
public class UserAgencyClientChanges {
    private final ModelChanges<User> userChanges;
    private final ModelChanges<Client> clientChanges;
    private final ModelChanges<Grants> grantsChanges;

    UserAgencyClientChanges(ModelChanges<User> userChanges, ModelChanges<Client> clientChanges,
                            ModelChanges<Grants> grantsChanges) {
        this.userChanges = userChanges;
        this.clientChanges = clientChanges;
        this.grantsChanges = grantsChanges;
    }

    public ModelChanges<User> getUserChanges() {
        return userChanges;
    }

    public ModelChanges<Client> getClientChanges() {
        return clientChanges;
    }

    public ModelChanges<Grants> getGrantsChanges() {
        return grantsChanges;
    }
}
