package ru.yandex.direct.api.v5.entity.agencyclients.validation;

import com.yandex.direct.api.v5.agencyclients.AgencyClientsSelectionCriteria;
import com.yandex.direct.api.v5.agencyclients.GetRequest;

import ru.yandex.direct.api.v5.common.validation.GetRequestGeneralValidator;
import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.api.v5.validation.DefectTypes;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.api.v5.validation.constraints.Constraints.eachNotNull;
import static ru.yandex.direct.api.v5.validation.constraints.Constraints.maxListSize;


public class GetRequestValidator {
    private static final int LOGINS_MAX_COUNT = 10_000;

    private GetRequestValidator() {
    }

    public static ValidationResult<GetRequest, DefectType> validateRequest(GetRequest request) {
        ItemValidationBuilder<GetRequest, DefectType> vb = ItemValidationBuilder.of(request);
        vb.item(request.getSelectionCriteria(), "SelectionCriteria")
                .checkBy(GetRequestValidator::validateSelectionCriteria, When.notNull());
        vb.checkBy(GetRequestGeneralValidator::validateRequest);
        return vb.getResult();
    }

    private static ValidationResult<AgencyClientsSelectionCriteria, DefectType> validateSelectionCriteria(
            AgencyClientsSelectionCriteria selectionCriteria) {
        ItemValidationBuilder<AgencyClientsSelectionCriteria, DefectType> vb =
                ItemValidationBuilder.of(selectionCriteria);
        vb.item(selectionCriteria.getLogins(), "Logins")
                .check(maxListSize(LOGINS_MAX_COUNT), DefectTypes.maxElementsInSelection(LOGINS_MAX_COUNT))
                .check(eachNotNull());
        return vb.getResult();
    }

}
