package ru.yandex.direct.api.v5.entity.agencyclients.validation;

import com.yandex.direct.api.v5.agencyclients.UpdateRequest;
import org.springframework.stereotype.Component;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.api.v5.validation.constraints.Constraints;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class UpdateAgencyClientRequestValidator {
    private static final int UPDATE_ITEM_COUNT = 1000;

    public ValidationResult<UpdateRequest, DefectType> validate(UpdateRequest request) {
        ItemValidationBuilder<UpdateRequest, DefectType> vb = ItemValidationBuilder.of(request);
        vb.item(request.getClients(), "Clients")
                .check(Constraints.maxListSize(UPDATE_ITEM_COUNT));
        return vb.getResult();
    }
}
