package ru.yandex.direct.api.v5.entity.audiencetargets;


import com.yandex.direct.api.v5.audiencetargets.AddRequest;
import com.yandex.direct.api.v5.audiencetargets.AddResponse;
import com.yandex.direct.api.v5.audiencetargets.ApiException;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetsPort;
import com.yandex.direct.api.v5.audiencetargets.DeleteRequest;
import com.yandex.direct.api.v5.audiencetargets.DeleteResponse;
import com.yandex.direct.api.v5.audiencetargets.GetRequest;
import com.yandex.direct.api.v5.audiencetargets.GetResponse;
import com.yandex.direct.api.v5.audiencetargets.ResumeRequest;
import com.yandex.direct.api.v5.audiencetargets.ResumeResponse;
import com.yandex.direct.api.v5.audiencetargets.SetBidsRequest;
import com.yandex.direct.api.v5.audiencetargets.SetBidsResponse;
import com.yandex.direct.api.v5.audiencetargets.SuspendRequest;
import com.yandex.direct.api.v5.audiencetargets.SuspendResponse;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.audiencetargets.delegate.AddAudienceTargetsDelegate;
import ru.yandex.direct.api.v5.entity.audiencetargets.delegate.DeleteAudienceTargetsDelegate;
import ru.yandex.direct.api.v5.entity.audiencetargets.delegate.GetAudienceTargetsDelegate;
import ru.yandex.direct.api.v5.entity.audiencetargets.delegate.ResumeAudienceTargetsDelegate;
import ru.yandex.direct.api.v5.entity.audiencetargets.delegate.SetBidsAudienceTargetsDelegate;
import ru.yandex.direct.api.v5.entity.audiencetargets.delegate.SuspendAudienceTargetsDelegate;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;

@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.CLIENT)
public class AudienceTargetsEndpoint implements AudienceTargetsPort {
    private static final String SERVICE_NAME = "audiencetargets";

    private final GetAudienceTargetsDelegate getAudienceTargetsDelegate;
    private final AddAudienceTargetsDelegate addAudienceTargetsDelegate;
    private final DeleteAudienceTargetsDelegate deleteAudienceTargetsDelegate2;
    private final SuspendAudienceTargetsDelegate suspendAudienceTargetsDelegate;
    private final ResumeAudienceTargetsDelegate resumeAudienceTargetsDelegate;
    private final SetBidsAudienceTargetsDelegate setBidsAudienceTargetsDelegate;
    private final GenericApiService genericApiService;

    @Autowired
    public AudienceTargetsEndpoint(AddAudienceTargetsDelegate addAudienceTargetsDelegate,
                                   GetAudienceTargetsDelegate getAudienceTargetsDelegate,
                                   DeleteAudienceTargetsDelegate deleteAudienceTargetsDelegate,
                                   SuspendAudienceTargetsDelegate suspendAudienceTargetsDelegate,
                                   ResumeAudienceTargetsDelegate resumeAudienceTargetsDelegate,
                                   SetBidsAudienceTargetsDelegate setBidsAudienceTargetsDelegate,
                                   GenericApiService genericApiService) {
        this.addAudienceTargetsDelegate = addAudienceTargetsDelegate;
        this.getAudienceTargetsDelegate = getAudienceTargetsDelegate;
        this.deleteAudienceTargetsDelegate2 = deleteAudienceTargetsDelegate;
        this.suspendAudienceTargetsDelegate = suspendAudienceTargetsDelegate;
        this.resumeAudienceTargetsDelegate = resumeAudienceTargetsDelegate;
        this.setBidsAudienceTargetsDelegate = setBidsAudienceTargetsDelegate;
        this.genericApiService = genericApiService;
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest parameters) throws ApiException {
        return genericApiService.doAction(getAudienceTargetsDelegate, parameters);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "add")
    @ApiResponse
    @Override
    public AddResponse add(@ApiRequest AddRequest parameters) throws ApiException {
        return genericApiService.doAction(addAudienceTargetsDelegate, parameters);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "delete")
    @ApiResponse
    @Override
    public DeleteResponse delete(@ApiRequest DeleteRequest parameters) throws ApiException {
        return genericApiService.doAction(deleteAudienceTargetsDelegate2, parameters);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "suspend")
    @ApiResponse
    @Override
    public SuspendResponse suspend(@ApiRequest SuspendRequest parameters) throws ApiException {
        return genericApiService.doAction(suspendAudienceTargetsDelegate, parameters);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "resume")
    @ApiResponse
    @Override
    public ResumeResponse resume(@ApiRequest ResumeRequest parameters) throws ApiException {
        return genericApiService.doAction(resumeAudienceTargetsDelegate, parameters);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "setBids")
    @ApiResponse
    @Override
    public SetBidsResponse setBids(@ApiRequest SetBidsRequest parameters) throws ApiException {
        return genericApiService.doAction(setBidsAudienceTargetsDelegate, parameters);
    }
}
