package ru.yandex.direct.api.v5.entity.audiencetargets.converter;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetSelectionCriteria;
import com.yandex.direct.api.v5.audiencetargets.AudienceTargetStateEnum;
import com.yandex.direct.api.v5.audiencetargets.GetRequest;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.retargeting.container.RetargetingSelection;

// todo maxlog: перенести в AudienceTargetsHelperConverter
@Component
@ParametersAreNonnullByDefault
public class AudienceTargetsGetRequestConverter implements Converter<GetRequest, RetargetingSelection> {
    @Override
    public RetargetingSelection convert(GetRequest getRequest) {
        RetargetingSelection selection = new RetargetingSelection();

        AudienceTargetSelectionCriteria selectionCriteria = getRequest.getSelectionCriteria();

        selection.setIds(emptyToNull(selectionCriteria.getIds()));
        selection.setAdGroupIds(emptyToNull(selectionCriteria.getAdGroupIds()));
        selection.setCampaignIds(emptyToNull(selectionCriteria.getCampaignIds()));
        selection.setRetargetingListIds(emptyToNull(selectionCriteria.getRetargetingListIds()));
        selection.setInterestIds(emptyToNull(selectionCriteria.getInterestIds()));
        selection.setSuspended(convertStatesToIsSuspended(selectionCriteria.getStates()));

        return selection;
    }

    @Nullable
    public static Boolean convertStatesToIsSuspended(List<AudienceTargetStateEnum> states) {
        Set<AudienceTargetStateEnum> statesSet = new HashSet<>(states);
        if (statesSet.isEmpty() || statesSet.containsAll(
                Arrays.asList(AudienceTargetStateEnum.ON, AudienceTargetStateEnum.SUSPENDED))) {
            return null;
        } else {
            return statesSet.contains(AudienceTargetStateEnum.SUSPENDED);
        }
    }

    @Nullable
    private static <T extends Collection> T emptyToNull(@Nullable T value) {
        if (value == null) {
            return null;
        }
        if (value.isEmpty()) {
            return null;
        }
        return value;
    }
}
