package ru.yandex.direct.api.v5.entity.audiencetargets.converter;

import com.yandex.direct.api.v5.audiencetargets.AudienceTargetGetItem;
import com.yandex.direct.api.v5.audiencetargets.ObjectFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.retargeting.model.TargetInterest;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertState;
import static ru.yandex.direct.api.v5.common.ConverterUtils.convertStrategyPriority;
import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

// todo maxlog: перенести в AudienceTargetsHelperConverter
@Component
public class TargetInterestConverter implements Converter<TargetInterest, AudienceTargetGetItem> {
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();

    @Override
    public AudienceTargetGetItem convert(TargetInterest targetInterest) {
        return new AudienceTargetGetItem()
                .withId(targetInterest.getId())
                .withAdGroupId(targetInterest.getAdGroupId())
                .withCampaignId(targetInterest.getCampaignId())
                .withRetargetingListId(OBJECT_FACTORY
                        .createAudienceTargetGetItemRetargetingListId(targetInterest.getRetargetingConditionId()))
                .withInterestId(OBJECT_FACTORY.createAudienceTargetGetItemInterestId(targetInterest.getInterestId()))
                .withState(convertState(targetInterest.getIsSuspended()))
                .withContextBid(convertToMicros(targetInterest.getPriceContext()))
                .withStrategyPriority(convertStrategyPriority(targetInterest.getAutobudgetPriority()));
    }
}
