package ru.yandex.direct.api.v5.entity.bidmodifiers;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.api.v5.validation.DefectTypes;
import ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectTranslations;
import ru.yandex.direct.core.validation.CommonDefectTranslations;
import ru.yandex.direct.i18n.types.Identity;

public class BidModifiersDefectTypes {
    private static CommonDefectTranslations commonTranslations() {
        return CommonDefectTranslations.INSTANCE;
    }

    private static BidModifiersDefectTranslations translations() {
        return BidModifiersDefectTranslations.INSTANCE;
    }

    public static DefectType campaignNotFound() {
        return DefectTypes.notFound()
                .withDetailedMessage(
                        (p, id) -> commonTranslations().campaignNotFoundDetailed(new Identity((Long) id)));
    }

    public static DefectType geoBidModifiersNotSupportedOnAdGroups() {
        return DefectTypes.notSupported()
                .withDetailedMessage((path, value) -> translations().geoBidModifiersNotSupportedOnAdGroupsDetailed());
    }

    public static DefectType duplicateRetargetingCondition() {
        return DefectTypes.duplicatedObject()
                .withDetailedMessage((path, value) -> translations().duplicateRetargetingConditionDetailed());
    }

    public static DefectType duplicateAdjustment() {
        return DefectTypes.duplicatedObject()
                .withDetailedMessage((path, value) -> translations().duplicateAdjustmentDetailed());
    }

    public static DefectType invalidPercentNotPositive() {
        return DefectTypes.invalidValueShouldBePositive()
                .withDetailedMessage((path, value) -> translations().invalidPercentNotPositive());
    }

    public static DefectType percentMustBeGreaterThanOrEqualToMin(int min) {
        return DefectTypes.invalidValue()
                .withDetailedMessage(
                        (path, value) -> translations().percentMustBeGreaterThanOrEqualToMin(new Identity(min)));
    }

    public static DefectType percentMustBeLessThanOrEqualToMax(int max) {
        return DefectTypes.invalidValue()
                .withDetailedMessage(
                        (path, value) -> translations().percentMustBeLessThanOrEqualToMax(new Identity(max)));
    }

    public static DefectType requiredAtLeastOneOfAgeOrGender() {
        return DefectTypes.requiredAtLeastOneOfFields()
                .withDetailedMessage(
                        (path, value) -> translations().requiredAtLeastOneOfAgeOrGender());
    }

    public static DefectType tooManyDemographyConditions(int max) {
        return DefectTypes.maxElementsExceeded(max)
                .withDetailedMessage(
                        (path, value) -> translations().tooManyDemographyConditions(new Identity(max)));
    }

    public static DefectType tooManyRetargetingConditions(int max) {
        return DefectTypes.maxElementsExceeded(max)
                .withDetailedMessage(
                        (path, value) -> translations().tooManyRetargetingConditions(new Identity(max)));
    }

    public static DefectType tooManyInventoryConditions(int max) {
        return DefectTypes.maxElementsExceeded(max)
                .withDetailedMessage(
                        (path, value) -> translations().tooManyInventoryConditions(new Identity(max)));
    }

    public static DefectType tooManyTrafaretPositionConditions(int max) {
        return DefectTypes.maxElementsExceeded(max)
                .withDetailedMessage(
                        (path, value) -> translations().tooManyTrafaretPositionConditions(new Identity(max)));
    }

    public static DefectType demographicsConditionsIntersection() {
        return DefectTypes.inconsistentState()
                .withDetailedMessage(
                        (path, value) -> translations().demographicsConditionsIntersection());
    }

    public static DefectType notSupportedMultiplier() {
        return DefectTypes.notSupported()
                .withDetailedMessage(
                        ((path, value) -> translations().notSupportedMultiplier()));
    }

    public static DefectType unsupportedRetargetingType() {
        return DefectTypes.inconsistentState()
                .withDetailedMessage(
                        ((path, value) -> translations().unsupportedRetargetingType()));
    }

    public static DefectType deviceBidModifiersAllZeros() {
        return DefectTypes.inconsistentState()
                .withDetailedMessage(
                        ((path, value) -> translations().deviceBidModifiersAllZeros()));
    }

    public static DefectType settingOsTypeNotAllowed() {
        return DefectTypes.inconsistentState()
                .withDetailedMessage(
                        ((path, value) -> translations().settingOsTypeNotAllowed()));
    }

    public static DefectType geoRegionsIntersection() {
        return DefectTypes.inconsistentState()
                .withDetailedMessage(
                        (path, value) -> translations().geoRegionsIntersection());
    }

    public static DefectType abSegmentsIntersection() {
        return DefectTypes.inconsistentState()
                .withDetailedMessage(
                        (path, value) -> translations().abSegmentsIntersection());
    }

    public static DefectType trafaretPositionsIntersection() {
        return DefectTypes.inconsistentState()
                .withDetailedMessage(
                        (path, value) -> translations().trafaretPositionsIntersection());
    }

    public static DefectType abSegmentNotFound(Long segmentId) {
        return DefectTypes.inconsistentState()
                .withDetailedMessage(
                        (path, value) -> translations().abSegmentNotFound(new Identity(segmentId)));
    }

    public static DefectType abSegmentSectionNotFound(Long sectionId) {
        return DefectTypes.inconsistentState()
                .withDetailedMessage(
                        (path, value) -> translations().abSegmentSectionNotFound(new Identity(sectionId)));
    }

    public static DefectType abSegmentBidModifiersNotSupportedOnAdGroups() {
        return DefectTypes.notSupported()
                .withDetailedMessage(
                        (path, value) -> translations().abSegmentBidModifiersNotSupportedOnAdGroupsDetailed());
    }

    public static DefectType addItemsLimitExceeded(int max) {
        return new DefectType(9300,
                commonTranslations().maxElementsPerRequestShort(),
                (path, value) -> translations().addItemsLimitExceeded(new Identity(max)));
    }

    public static DefectType toggleItemsLimitExceeded(int max) {
        return new DefectType(9300,
                commonTranslations().maxElementsPerRequestShort(),
                (path, value) -> translations().toggleItemsLimitExceeded(new Identity(max)));
    }

    public static DefectType notFound() {
        return DefectTypes.notFound()
                .withDetailedMessage(translations().notFoundDetailed());
    }

    public static DefectType conflictApplyingChanges() {
        return DefectTypes.inconsistentState()
                .withDetailedMessage(translations().conflictApplyingChanges());
    }

    public static DefectType setItemsLimitExceeded(int max) {
        return new DefectType(9300,
                commonTranslations().maxElementsPerRequestShort(),
                (path, value) -> translations().setItemsLimitExceeded(new Identity(max)));
    }

    public static DefectType adjustmentNotFound() {
        return DefectTypes.notFound()
                .withDetailedMessage(
                        (p, id) -> translations().notFoundDetailed());
    }

    public static DefectType adjustmentSetNotFound() {
        return DefectTypes.notFound()
                .withDetailedMessage(
                        (p, id) -> translations().setNotFoundDetailed());
    }

    public static DefectType duplicateSingleAdjustment() {
        return DefectTypes.duplicatedObject()
                .withDetailedMessage((path, value) -> translations().duplicateSingleAdjustmentDetailed());
    }

    public static DefectType nonexistentRegionIds(String regionIds) {
        return DefectTypes.invalidValue()
                .withDetailedMessage((path, value) -> translations().nonexistentRegionIds(regionIds));
    }

    public static DefectType invalidExpressionLiteral() {
        return DefectTypes.inconsistentState()
                .withDetailedMessage(
                        ((path, value) -> translations().invalidExpressionLiteral()));
    }

    public static DefectType expressionAdjustmentIsConstantForAnyValues() {
        return DefectTypes.inconsistentState()
                .withDetailedMessage(
                        ((path, value) -> translations().expressionAdjustmentIsConstantForAnyValues()));
    }

    public static DefectType expressionConditionsIntersection() {
        return DefectTypes.inconsistentState()
                .withDetailedMessage(
                        ((path, value) -> translations().expressionConditionsIntersection()));
    }

    public static DefectType oneTypeUsedTwiceInComplexModifier() {
        return DefectTypes.inconsistentState()
                .withDetailedMessage(
                        ((path, value) -> translations().oneTypeUsedTwiceInComplexModifier()));
    }
}
