package ru.yandex.direct.api.v5.entity.bidmodifiers;

import com.yandex.direct.api.v5.bidmodifiers.AddRequest;
import com.yandex.direct.api.v5.bidmodifiers.AddResponse;
import com.yandex.direct.api.v5.bidmodifiers.ApiException;
import com.yandex.direct.api.v5.bidmodifiers.BidModifiersPort;
import com.yandex.direct.api.v5.bidmodifiers.DeleteRequest;
import com.yandex.direct.api.v5.bidmodifiers.DeleteResponse;
import com.yandex.direct.api.v5.bidmodifiers.GetRequest;
import com.yandex.direct.api.v5.bidmodifiers.GetResponse;
import com.yandex.direct.api.v5.bidmodifiers.SetRequest;
import com.yandex.direct.api.v5.bidmodifiers.SetResponse;
import com.yandex.direct.api.v5.bidmodifiers.ToggleRequest;
import com.yandex.direct.api.v5.bidmodifiers.ToggleResponse;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.bidmodifiers.delegate.AddBidModifiersDelegate;
import ru.yandex.direct.api.v5.entity.bidmodifiers.delegate.DeleteBidModifiersDelegate;
import ru.yandex.direct.api.v5.entity.bidmodifiers.delegate.GetBidModifiersDelegate;
import ru.yandex.direct.api.v5.entity.bidmodifiers.delegate.SetBidModifiersDelegate;
import ru.yandex.direct.api.v5.entity.bidmodifiers.delegate.ToggleBidModifiersDelegate;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;
import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;

@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.CLIENT)
public class BidModifiersEndpoint implements BidModifiersPort {
    private static final String SERVICE_NAME = "bidmodifiers";

    private final GenericApiService genericApiService;
    private final GetBidModifiersDelegate getBidModifiersDelegate;
    private final AddBidModifiersDelegate addBidModifiersDelegate;
    private final DeleteBidModifiersDelegate deleteBidModifiersDelegate;
    private final SetBidModifiersDelegate setBidModifiersDelegate;
    private final ToggleBidModifiersDelegate toggleBidModifiersDelegate;

    @Autowired
    public BidModifiersEndpoint(GenericApiService genericApiService,
                                GetBidModifiersDelegate getBidModifiersDelegate,
                                AddBidModifiersDelegate addBidModifiersDelegate,
                                DeleteBidModifiersDelegate deleteBidModifiersDelegate,
                                SetBidModifiersDelegate setBidModifiersDelegate,
                                ToggleBidModifiersDelegate toggleBidModifiersDelegate) {
        this.getBidModifiersDelegate = getBidModifiersDelegate;
        this.genericApiService = genericApiService;
        this.addBidModifiersDelegate = addBidModifiersDelegate;
        this.deleteBidModifiersDelegate = deleteBidModifiersDelegate;
        this.toggleBidModifiersDelegate = toggleBidModifiersDelegate;
        this.setBidModifiersDelegate = setBidModifiersDelegate;
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "add")
    @ApiResponse
    @Override
    public AddResponse add(@ApiRequest AddRequest parameters) throws ApiException {
        return genericApiService.doAction(addBidModifiersDelegate, parameters);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "set")
    @ApiResponse
    @Override
    public SetResponse set(@ApiRequest SetRequest parameters) throws ApiException {
        return genericApiService.doAction(setBidModifiersDelegate, parameters);
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest parameters) throws ApiException {
        return genericApiService.doAction(getBidModifiersDelegate, parameters);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "delete")
    @ApiResponse
    @Override
    public DeleteResponse delete(@ApiRequest DeleteRequest parameters) throws ApiException {
        return genericApiService.doAction(deleteBidModifiersDelegate, parameters);
    }

    @PreAuthorizeWrite
    @ApiMethod(service = SERVICE_NAME, operation = "toggle")
    @ApiResponse
    @Override
    public ToggleResponse toggle(@ApiRequest ToggleRequest parameters) throws ApiException {
        return genericApiService.doAction(toggleBidModifiersDelegate, parameters);
    }
}
