package ru.yandex.direct.api.v5.entity.bidmodifiers;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.yandex.direct.api.v5.general.IncomeGradeEnum;
import one.util.streamex.EntryStream;

import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;

public class Constants {
    public static final int CAMPAIGN_IDS_LIMIT = 1000;
    public static final int ADGROUP_IDS_LIMIT = 10_000;
    public static final int IDS_LIMIT = 10_000;

    // Ограничение на выборку данных из БД, ядро может вернуть чуть больше корректировок (т.к. возвращается весь
    // набор целиком)
    public static final int GET_HARD_LIMIT = 120_000;

    // Разрешено создавать не более 1000 наборов корректировок в одном запросе
    public static final int BID_MODIFIERS_ADD_ITEMS_LIMIT = 1000;

    // Разрешено изменять не более 1000 наборов корректировок в одном запросе
    public static final int BID_MODIFIERS_SET_ITEMS_LIMIT = 1000;

    // Разрешено включать/выключать не более 1000 наборов корректировок в одном запросе
    public static final int BID_MODIFIERS_TOGGLE_ITEMS_LIMIT = 1000;

    // Разрешено удалять не более 1000 наборов корректировок в одном запросе
    public static final int BID_MODIFIERS_DELETE_ITEMS_LIMIT = 1000;

    private static final String API5_ALLOWED_ADJUSTMENT_FIELDS = getAdjustmentFields();

    private static final Set<BidModifierType> API5_ALLOWED_BID_MODIFIER_TYPES = Set.of(
            BidModifierType.DEMOGRAPHY_MULTIPLIER,
            BidModifierType.DESKTOP_MULTIPLIER,
            BidModifierType.DESKTOP_ONLY_MULTIPLIER,
            BidModifierType.GEO_MULTIPLIER,
            BidModifierType.MOBILE_MULTIPLIER,
            BidModifierType.TABLET_MULTIPLIER,
            BidModifierType.PERFORMANCE_TGO_MULTIPLIER,
            BidModifierType.RETARGETING_MULTIPLIER,
            BidModifierType.VIDEO_MULTIPLIER,
            BidModifierType.TRAFARET_POSITION_MULTIPLIER,
            BidModifierType.PRISMA_INCOME_GRADE_MULTIPLIER,
            BidModifierType.SMARTTV_MULTIPLIER);


    public static final Map<IncomeGradeEnum, String> INCOME_GRADE_LITERAL_VALUE_BY_INCOME_GRADE_ENUM = Map.of(
            IncomeGradeEnum.VERY_HIGH, "2",
            IncomeGradeEnum.HIGH, "1",
            IncomeGradeEnum.ABOVE_AVERAGE, "0"
    );

    public static final Map<String, IncomeGradeEnum> INCOME_GRADE_ENUM_BY_INCOME_GRADE_LITERAL_VALUE =
            EntryStream.of(INCOME_GRADE_LITERAL_VALUE_BY_INCOME_GRADE_ENUM).invert().toMap();

    private static String getAdjustmentFields() {
        //Порядок важен, т.к. на него завязаны тесты в aqua
        List<String> fields = List.of(
                "MobileAdjustment",
                "DemographicsAdjustments",
                "RetargetingAdjustments",
                "RegionalAdjustments",
                "VideoAdjustment",
                "DesktopAdjustment",
                "SmartAdAdjustment",
                "SerpLayoutAdjustments",
                "IncomeGradeAdjustments",
                "SmartTvAdjustment",
                "TabletAdjustment",
                "DesktopOnlyAdjustment"
        );
        return String.join(", ", fields);
    }

    public static String getApi5AllowedAdjustments() {
        return API5_ALLOWED_ADJUSTMENT_FIELDS;
    }

    public static Set<BidModifierType> getApi5AllowedBidModifierTypes() {
        return API5_ALLOWED_BID_MODIFIER_TYPES;
    }
}
