package ru.yandex.direct.api.v5.entity.bidmodifiers.delegate;

import java.util.Arrays;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.DemographicsAdjustmentFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.DesktopAdjustmentFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.DesktopOnlyAdjustmentFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.IncomeGradeAdjustmentFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.MobileAdjustmentFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.RegionalAdjustmentFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.RetargetingAdjustmentFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.SerpLayoutAdjustmentFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.SmartAdAdjustmentFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.SmartTvAdjustmentFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.TabletAdjustmentFieldEnum;
import com.yandex.direct.api.v5.bidmodifiers.VideoAdjustmentFieldEnum;

/**
 * Все возможные желаемые поля в одном месте для того, чтобы делегат мог оперировать одним перечислением в методе
 * {@link GetBidModifiersDelegate#convertGetResponse}
 */
public enum BidModifierAnyFieldEnum {
    BID_MODIFIER_ID(BidModifierFieldEnum.class, BidModifierFieldEnum.ID),
    BID_MODIFIER_CAMPAIGN_ID(BidModifierFieldEnum.class, BidModifierFieldEnum.CAMPAIGN_ID),
    BID_MODIFIER_AD_GROUP_ID(BidModifierFieldEnum.class, BidModifierFieldEnum.AD_GROUP_ID),
    BID_MODIFIER_LEVEL(BidModifierFieldEnum.class, BidModifierFieldEnum.LEVEL),
    BID_MODIFIER_TYPE(BidModifierFieldEnum.class, BidModifierFieldEnum.TYPE),

    MOBILE_ADJUSTMENT_BID_MODIFIER(MobileAdjustmentFieldEnum.class, MobileAdjustmentFieldEnum.BID_MODIFIER),
    MOBILE_ADJUSTMENT_OPERATING_SYSTEM_TYPE(MobileAdjustmentFieldEnum.class,
            MobileAdjustmentFieldEnum.OPERATING_SYSTEM_TYPE),
    DESKTOP_ADJUSTMENT_BID_MODIFIER(DesktopAdjustmentFieldEnum.class, DesktopAdjustmentFieldEnum.BID_MODIFIER),
    TABLET_ADJUSTMENT_BID_MODIFIER(TabletAdjustmentFieldEnum.class, TabletAdjustmentFieldEnum.BID_MODIFIER),
    TABLET_ADJUSTMENT_OPERATING_SYSTEM_TYPE(TabletAdjustmentFieldEnum.class,
            TabletAdjustmentFieldEnum.OPERATING_SYSTEM_TYPE),
    DESKTOP_ONLY_ADJUSTMENT_BID_MODIFIER(
            DesktopOnlyAdjustmentFieldEnum.class, DesktopOnlyAdjustmentFieldEnum.BID_MODIFIER),
    SMART_TV_ADJUSTMENT_BID_MODIFIER(SmartTvAdjustmentFieldEnum.class, SmartTvAdjustmentFieldEnum.BID_MODIFIER),

    REGIONAL_ADJUSTMENT_REGION_ID(RegionalAdjustmentFieldEnum.class, RegionalAdjustmentFieldEnum.REGION_ID),
    REGIONAL_ADJUSTMENT_BID_MODIFIER(RegionalAdjustmentFieldEnum.class, RegionalAdjustmentFieldEnum.BID_MODIFIER),
    REGIONAL_ADJUSTMENT_ENABLED(RegionalAdjustmentFieldEnum.class, RegionalAdjustmentFieldEnum.ENABLED),

    DEMOGRAPHICS_ADJUSTMENT_GENDER(DemographicsAdjustmentFieldEnum.class, DemographicsAdjustmentFieldEnum.GENDER),
    DEMOGRAPHICS_ADJUSTMENT_AGE(DemographicsAdjustmentFieldEnum.class, DemographicsAdjustmentFieldEnum.AGE),
    DEMOGRAPHICS_ADJUSTMENT_BID_MODIFIER(DemographicsAdjustmentFieldEnum.class,
            DemographicsAdjustmentFieldEnum.BID_MODIFIER),
    DEMOGRAPHICS_ADJUSTMENT_ENABLED(DemographicsAdjustmentFieldEnum.class, DemographicsAdjustmentFieldEnum.ENABLED),

    RETARGETING_ADJUSTMENT_RETARGETING_CONDITION_ID(RetargetingAdjustmentFieldEnum.class,
            RetargetingAdjustmentFieldEnum.RETARGETING_CONDITION_ID),
    RETARGETING_ADJUSTMENT_BID_MODIFIER(RetargetingAdjustmentFieldEnum.class,
            RetargetingAdjustmentFieldEnum.BID_MODIFIER),
    RETARGETING_ADJUSTMENT_ACCESSIBLE(RetargetingAdjustmentFieldEnum.class, RetargetingAdjustmentFieldEnum.ACCESSIBLE),
    RETARGETING_ADJUSTMENT_ENABLED(RetargetingAdjustmentFieldEnum.class, RetargetingAdjustmentFieldEnum.ENABLED),

    VIDEO_ADJUSTMENT_BID_MODIFIER(VideoAdjustmentFieldEnum.class, VideoAdjustmentFieldEnum.BID_MODIFIER),

    SMART_AD_ADJUSTMENT_BID_MODIFIER(SmartAdAdjustmentFieldEnum.class, SmartAdAdjustmentFieldEnum.BID_MODIFIER),

    SERP_LAYOUT_SERP_LAYOUT(SerpLayoutAdjustmentFieldEnum.class, SerpLayoutAdjustmentFieldEnum.SERP_LAYOUT),
    SERP_LAYOUT_BID_MODIFIER(SerpLayoutAdjustmentFieldEnum.class, SerpLayoutAdjustmentFieldEnum.BID_MODIFIER),
    SERP_LAYOUT_ENABLED(SerpLayoutAdjustmentFieldEnum.class, SerpLayoutAdjustmentFieldEnum.ENABLED),

    INCOME_GRADE_ADJUSTMENT_BID_MODIFIER(IncomeGradeAdjustmentFieldEnum.class,
            IncomeGradeAdjustmentFieldEnum.BID_MODIFIER),

    INCOME_GRADE_ADJUSTMENT_GRADE(IncomeGradeAdjustmentFieldEnum.class, IncomeGradeAdjustmentFieldEnum.GRADE),

    INCOME_GRADE_ADJUSTMENT_ENABLED(IncomeGradeAdjustmentFieldEnum.class, IncomeGradeAdjustmentFieldEnum.ENABLED);

    private final Class<?> enumClazz;
    private final Enum value;

    BidModifierAnyFieldEnum(Class<?> enumClazz, Enum value) {
        this.enumClazz = enumClazz;
        this.value = value;
    }

    public Class<?> getEnumClazz() {
        return enumClazz;
    }

    public Enum getValue() {
        return value;
    }

    public static BidModifierAnyFieldEnum fromBidModifierFieldEnum(BidModifierFieldEnum bidModifierFieldEnum) {
        return Arrays.stream(BidModifierAnyFieldEnum.values())
                .filter(v -> v.getEnumClazz().equals(BidModifierFieldEnum.class) && v.getValue()
                        .equals(bidModifierFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static BidModifierAnyFieldEnum fromMobileAdjustmentFieldEnum(
            MobileAdjustmentFieldEnum mobileAdjustmentFieldEnum) {
        return Arrays.stream(BidModifierAnyFieldEnum.values())
                .filter(v -> v.getEnumClazz().equals(MobileAdjustmentFieldEnum.class) && v.getValue()
                        .equals(mobileAdjustmentFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static BidModifierAnyFieldEnum fromDesktopAdjustmentFieldEnum(
            DesktopAdjustmentFieldEnum desktopAdjustmentFieldEnum) {
        return Arrays.stream(BidModifierAnyFieldEnum.values())
                .filter(v -> v.getEnumClazz().equals(DesktopAdjustmentFieldEnum.class) && v.getValue()
                        .equals(desktopAdjustmentFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static BidModifierAnyFieldEnum fromTabletAdjustmentFieldEnum(
            TabletAdjustmentFieldEnum tabletAdjustmentFieldEnum) {
        return Arrays.stream(BidModifierAnyFieldEnum.values())
                .filter(v -> v.getEnumClazz().equals(TabletAdjustmentFieldEnum.class) && v.getValue()
                        .equals(tabletAdjustmentFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static BidModifierAnyFieldEnum fromDesktopOnlyAdjustmentFieldEnum(
            DesktopOnlyAdjustmentFieldEnum desktopOnlyAdjustmentFieldEnum) {
        return Arrays.stream(BidModifierAnyFieldEnum.values())
                .filter(v -> v.getEnumClazz().equals(DesktopOnlyAdjustmentFieldEnum.class) && v.getValue()
                        .equals(desktopOnlyAdjustmentFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static BidModifierAnyFieldEnum fromSmartTvAdjustmentFieldEnum(
            SmartTvAdjustmentFieldEnum smartTvAdjustmentFieldEnum) {
        return Arrays.stream(BidModifierAnyFieldEnum.values())
                .filter(v -> v.getEnumClazz().equals(SmartTvAdjustmentFieldEnum.class) && v.getValue()
                        .equals(smartTvAdjustmentFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static BidModifierAnyFieldEnum fromRegionalAdjustmentFieldEnum(
            RegionalAdjustmentFieldEnum regionalAdjustmentFieldEnum) {
        return Arrays.stream(BidModifierAnyFieldEnum.values())
                .filter(v -> v.getEnumClazz().equals(RegionalAdjustmentFieldEnum.class) && v.getValue()
                        .equals(regionalAdjustmentFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static BidModifierAnyFieldEnum fromDemographicsAdjustmentFieldEnum(
            DemographicsAdjustmentFieldEnum demographicsAdjustmentFieldEnum) {
        return Arrays.stream(BidModifierAnyFieldEnum.values())
                .filter(v -> v.getEnumClazz().equals(DemographicsAdjustmentFieldEnum.class) && v.getValue()
                        .equals(demographicsAdjustmentFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static BidModifierAnyFieldEnum fromRetargetingAdjustmentFieldEnum(
            RetargetingAdjustmentFieldEnum retargetingAdjustmentFieldEnum) {
        return Arrays.stream(BidModifierAnyFieldEnum.values())
                .filter(v -> v.getEnumClazz().equals(RetargetingAdjustmentFieldEnum.class) && v.getValue()
                        .equals(retargetingAdjustmentFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static BidModifierAnyFieldEnum fromVideoAdjustmentFieldEnum(
            VideoAdjustmentFieldEnum videoAdjustmentFieldEnum) {
        return Arrays.stream(BidModifierAnyFieldEnum.values())
                .filter(v -> v.getEnumClazz().equals(VideoAdjustmentFieldEnum.class) && v.getValue()
                        .equals(videoAdjustmentFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static BidModifierAnyFieldEnum fromSmartAdjustmentFieldEnum(
            SmartAdAdjustmentFieldEnum smartAdAdjustmentFieldEnum) {
        return Arrays.stream(BidModifierAnyFieldEnum.values())
                .filter(v -> v.getEnumClazz().equals(SmartAdAdjustmentFieldEnum.class) && v.getValue()
                        .equals(smartAdAdjustmentFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static BidModifierAnyFieldEnum fromSerpLayoutAdjustmentFieldEnum(
            SerpLayoutAdjustmentFieldEnum serpLayoutAdjustmentFieldEnum) {
        return Arrays.stream(BidModifierAnyFieldEnum.values())
                .filter(v -> v.getEnumClazz().equals(SerpLayoutAdjustmentFieldEnum.class) && v.getValue()
                        .equals(serpLayoutAdjustmentFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

    public static BidModifierAnyFieldEnum fromIncomeGradeAdjustmentFieldEnum(
            IncomeGradeAdjustmentFieldEnum incomeGradeAdjustmentFieldEnum) {
        return Arrays.stream(BidModifierAnyFieldEnum.values())
                .filter(v -> v.getEnumClazz().equals(IncomeGradeAdjustmentFieldEnum.class) && v.getValue()
                        .equals(incomeGradeAdjustmentFieldEnum))
                .findFirst().orElseThrow(IllegalStateException::new);
    }

}
