package ru.yandex.direct.api.v5.entity.bidmodifiers.validation;

import java.util.Map;
import java.util.Set;

import com.yandex.direct.api.v5.bidmodifiers.BidModifierAddItem;

import ru.yandex.direct.api.v5.validation.DefectType;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.validation.builder.Constraint;

import static ru.yandex.direct.api.v5.entity.ads.AdsDefectTypes.notSupportedAdGroupType;

public class BidModifiersAdGroupTypeConstraints {

    public static Constraint<BidModifierAddItem, DefectType> allowedAdGroupType(Map<Long, AdGroupType> adGroupTypes,
                                                                                Set<AdGroupType> allowedAdGroupTypes) {
        return Constraint.fromPredicate(item -> adGroupTypes.get(item.getAdGroupId()) == null
                        || allowedAdGroupTypes.contains(adGroupTypes.get(item.getAdGroupId())),
                notSupportedAdGroupType());
    }
}
