package ru.yandex.direct.api.v5.entity.bidmodifiers.validation;

import ru.yandex.direct.api.v5.common.validation.DefaultApiPresentations;
import ru.yandex.direct.api.v5.common.validation.DefectPresentationsHolder;
import ru.yandex.direct.api.v5.entity.bidmodifiers.BidModifiersDefectTypes;
import ru.yandex.direct.api.v5.validation.DefectTypes;
import ru.yandex.direct.core.entity.bidmodifiers.validation.BidModifiersDefectIds;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefectIds;
import ru.yandex.direct.validation.defect.ids.NumberDefectIds;
import ru.yandex.direct.validation.result.DefectIds;

import static java.util.stream.Collectors.joining;
import static ru.yandex.direct.api.v5.entity.bidmodifiers.BidModifiersDefectTypes.conflictApplyingChanges;
import static ru.yandex.direct.api.v5.validation.DefectTypes.alreadyExists;

public class BidModifiersDefectPresentations {

    public static final DefectPresentationsHolder HOLDER = DefectPresentationsHolder
            .builderWithFallback(DefaultApiPresentations.HOLDER)
            .register(
                    BidModifiersDefectIds.LimitOffsetDefects.BID_MODIFIERS_GET_HARD_LIMIT_EXCEEDED,
                    DefectTypes::tooBroadSelectionClause
            )
            // Переопределяем дефолтное представление для CAMPAIGN_NOT_FOUND, т.к. в нашем случае
            // в качестве модели не bean, а просто long id
            .register(
                    CampaignDefectIds.Gen.CAMPAIGN_NOT_FOUND,
                    t -> BidModifiersDefectTypes.campaignNotFound()
            )
            .register(
                    DefectIds.OBJECT_NOT_FOUND,
                    t -> BidModifiersDefectTypes.notFound())
            .register(
                    BidModifiersDefectIds.LimitOffsetDefects.BID_MODIFIERS_ADD_ITEMS_LIMIT_EXCEEDED,
                    BidModifiersDefectTypes::addItemsLimitExceeded
            )
            .register(
                    BidModifiersDefectIds.LimitOffsetDefects.BID_MODIFIERS_SET_ITEMS_LIMIT_EXCEEDED,
                    BidModifiersDefectTypes::setItemsLimitExceeded
            )
            .register(
                    BidModifiersDefectIds.LimitOffsetDefects.BID_MODIFIERS_TOGGLE_ITEMS_LIMIT_EXCEEDED,
                    BidModifiersDefectTypes::toggleItemsLimitExceeded
            )
            .register(
                    BidModifiersDefectIds.ModelDefects.REQUIRED_AT_LEAST_ONE_OF_FIELDS,
                    fields -> DefectTypes.requiredAtLeastOneOfFields(fields.stream().collect(joining(", ")))
            )
            .register(
                    BidModifiersDefectIds.ModelDefects.POSSIBLE_ONLY_ONE_FIELD,
                    fields -> DefectTypes.possibleOnlyOneField(fields.stream().collect(joining(", ")))
            )
            .register(
                    BidModifiersDefectIds.GeneralDefects.GEO_BID_MODIFIERS_NOT_SUPPORTED_ON_ADGROUPS,
                    t -> BidModifiersDefectTypes.geoBidModifiersNotSupportedOnAdGroups()
            )
            .register(
                    BidModifiersDefectIds.GeneralDefects.DUPLICATE_RETARGETING_CONDITION,
                    t -> BidModifiersDefectTypes.duplicateRetargetingCondition()
            )
            .register(
                    BidModifiersDefectIds.GeneralDefects.DUPLICATE_ADJUSTMENT,
                    t -> BidModifiersDefectTypes.duplicateAdjustment()
            )
            .register(
                    BidModifiersDefectIds.GeneralDefects.DUPLICATE_SINGLE_ADJUSTMENT,
                    t -> BidModifiersDefectTypes.duplicateSingleAdjustment()
            )
            .register(
                    BidModifiersDefectIds.GeneralDefects.INVALID_PERCENT_SHOULD_BE_POSITIVE,
                    t -> BidModifiersDefectTypes.invalidPercentNotPositive()
            )
            .register(NumberDefectIds.MUST_BE_GREATER_THAN_OR_EQUAL_TO_MIN,
                    t -> BidModifiersDefectTypes.percentMustBeGreaterThanOrEqualToMin(t.getMin().intValue())
            )
            .register(NumberDefectIds.MUST_BE_LESS_THEN_OR_EQUAL_TO_MAX,
                    t -> BidModifiersDefectTypes.percentMustBeLessThanOrEqualToMax(t.getMax().intValue())
            )
            .register(BidModifiersDefectIds.GeneralDefects.REQUIRED_AT_LEAST_ONE_OF_AGE_OR_GENDER,
                    t -> BidModifiersDefectTypes.requiredAtLeastOneOfAgeOrGender()
            )
            .register(BidModifiersDefectIds.Number.TOO_MANY_DEMOGRAPHY_CONDITIONS,
                    t -> BidModifiersDefectTypes.tooManyDemographyConditions(t.getMax().intValue())
            )
            .register(BidModifiersDefectIds.Number.TOO_MANY_RETARGETING_CONDITIONS,
                    t -> BidModifiersDefectTypes.tooManyRetargetingConditions(t.getMax().intValue())
            )
            .register(BidModifiersDefectIds.Number.TOO_MANY_INVENTORY_CONDITIONS,
                    t -> BidModifiersDefectTypes.tooManyInventoryConditions(t.getMax().intValue())
            )
            .register(BidModifiersDefectIds.Number.TOO_MANY_TRAFARET_POSITION_CONDITIONS,
                    t -> BidModifiersDefectTypes.tooManyTrafaretPositionConditions(t.getMax().intValue())
            )
            .register(BidModifiersDefectIds.GeneralDefects.DEMOGRAPHICS_CONDITIONS_INTERSECTION,
                    t -> BidModifiersDefectTypes.demographicsConditionsIntersection()
            )
            .register(BidModifiersDefectIds.GeneralDefects.NOT_SUPPORTED_MULTIPLIER,
                    t -> BidModifiersDefectTypes.notSupportedMultiplier()
            )
            .register(BidModifiersDefectIds.GeneralDefects.GEO_REGIONS_INTERSECTION,
                    t -> BidModifiersDefectTypes.geoRegionsIntersection()
            )
            .register(BidModifiersDefectIds.GeneralDefects.TRAFARET_POSITIONS_INTERSECTION,
                    t -> BidModifiersDefectTypes.trafaretPositionsIntersection()
            )
            .register(BidModifiersDefectIds.GeneralDefects.SINGLE_VALUE_MODIFIER_ALREADY_EXISTS,
                    t -> alreadyExists()
            )
            .register(BidModifiersDefectIds.GeneralDefects.CONFLICT_APPLYING_CHANGES,
                    t -> conflictApplyingChanges()
            )
            .register(
                    BidModifiersDefectIds.GeneralDefects.ADJUSTMENT_NOT_FOUND,
                    t -> BidModifiersDefectTypes.adjustmentNotFound()
            )
            .register(
                    BidModifiersDefectIds.GeneralDefects.ADJUSTMENT_SET_NOT_FOUND,
                    t -> BidModifiersDefectTypes.adjustmentSetNotFound()
            )
            .register(
                    BidModifiersDefectIds.GeneralDefects.AB_SEGMENT_BID_MODIFIERS_INTERSECTION,
                    t -> BidModifiersDefectTypes.abSegmentsIntersection()
            )
            .register(
                    BidModifiersDefectIds.IdParametrized.AB_SEGMENT_NOT_FOUND,
                    t -> BidModifiersDefectTypes.abSegmentNotFound(t.getId())
            )
            .register(
                    BidModifiersDefectIds.IdParametrized.AB_SEGMENT_SECTION_NOT_FOUND,
                    t -> BidModifiersDefectTypes.abSegmentSectionNotFound(t.getId())
            )
            .register(
                    BidModifiersDefectIds.GeneralDefects.AB_SEGMENT_BID_MODIFIERS_NOT_SUPPORTED_ON_ADGROUPS,
                    t -> BidModifiersDefectTypes.abSegmentBidModifiersNotSupportedOnAdGroups()
            )
            .register(
                    BidModifiersDefectIds.RegionIdsDefects.NONEXISTENT_REGION_IDS,
                    BidModifiersDefectTypes::nonexistentRegionIds)
            .register(
                    BidModifiersDefectIds.GeneralDefects.UNSUPPORTED_RETARGETING_TYPE,
                    t -> BidModifiersDefectTypes.unsupportedRetargetingType()
            )
            .register(
                    BidModifiersDefectIds.GeneralDefects.DEVICE_BID_MODIFIERS_ALL_ZEROS,
                    t -> BidModifiersDefectTypes.deviceBidModifiersAllZeros()
            )
            .register(
                    BidModifiersDefectIds.GeneralDefects.SETTING_OS_TYPE_NOT_ALLOWED,
                    t -> BidModifiersDefectTypes.settingOsTypeNotAllowed()
            )
            .register(
                    BidModifiersDefectIds.GeneralDefects.INVALID_EXPRESSION_LITERAL,
                    t -> BidModifiersDefectTypes.invalidExpressionLiteral()
            )
            .register(
                    BidModifiersDefectIds.GeneralDefects.EXPRESSION_ADJUSTMENT_IS_CONSTANT_FOR_ANY_VALUES,
                    t -> BidModifiersDefectTypes.expressionAdjustmentIsConstantForAnyValues()
            )
            .register(
                    BidModifiersDefectIds.GeneralDefects.EXPRESSION_CONDITIONS_INTERSECTION,
                    t -> BidModifiersDefectTypes.expressionConditionsIntersection()
            )
            .register(
                    BidModifiersDefectIds.GeneralDefects.ONE_TYPE_USED_TWICE_IN_COMPLEX_MODIFIER,
                    t -> BidModifiersDefectTypes.oneTypeUsedTwiceInComplexModifier()
            )
            .build();
}
