package ru.yandex.direct.api.v5.entity.bids;

import com.yandex.direct.api.v5.bids.ApiException;
import com.yandex.direct.api.v5.bids.BidsPort;
import com.yandex.direct.api.v5.bids.GetRequest;
import com.yandex.direct.api.v5.bids.GetResponse;
import com.yandex.direct.api.v5.bids.SetAutoRequest;
import com.yandex.direct.api.v5.bids.SetAutoResponse;
import com.yandex.direct.api.v5.bids.SetRequest;
import com.yandex.direct.api.v5.bids.SetResponse;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.api.v5.entity.GenericApiService;
import ru.yandex.direct.api.v5.entity.bids.delegate.GetBidsDelegate;
import ru.yandex.direct.api.v5.entity.bids.delegate.SetAutoBidsDelegate;
import ru.yandex.direct.api.v5.entity.bids.delegate.SetBidsDelegate;
import ru.yandex.direct.api.v5.ws.annotation.ApiMethod;
import ru.yandex.direct.api.v5.ws.annotation.ApiRequest;
import ru.yandex.direct.api.v5.ws.annotation.ApiResponse;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceEndpoint;
import ru.yandex.direct.api.v5.ws.annotation.ApiServiceType;
import ru.yandex.direct.api.v5.ws.annotation.ServiceType;
import ru.yandex.direct.core.security.authorization.PreAuthorizeRead;

@ApiServiceEndpoint
@ApiServiceType(type = ServiceType.CLIENT)
public class BidsEndpoint implements BidsPort {
    private static final String SERVICE_NAME = "bids";

    private final GenericApiService genericApiService;
    private final GetBidsDelegate getBidsDelegate;
    private final SetBidsDelegate setBidsDelegate;
    private final SetAutoBidsDelegate setAutoBidsDelegate;

    @Autowired
    public BidsEndpoint(GenericApiService genericApiService,
                        GetBidsDelegate getBidsDelegate,
                        SetBidsDelegate setBidsDelegate,
                        SetAutoBidsDelegate setAutoBidsDelegate) {
        this.genericApiService = genericApiService;
        this.getBidsDelegate = getBidsDelegate;
        this.setBidsDelegate = setBidsDelegate;
        this.setAutoBidsDelegate = setAutoBidsDelegate;
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "get")
    @ApiResponse
    @Override
    public GetResponse get(@ApiRequest GetRequest getRequest) throws ApiException {
        return genericApiService.doAction(getBidsDelegate, getRequest);
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "set")
    @ApiResponse
    @Override
    public SetResponse set(@ApiRequest SetRequest parameters) throws ApiException {
        return genericApiService.doAction(setBidsDelegate, parameters);
    }

    @PreAuthorizeRead
    @ApiMethod(service = SERVICE_NAME, operation = "setAuto")
    @ApiResponse
    @Override
    public SetAutoResponse setAuto(@ApiRequest SetAutoRequest parameters) throws ApiException {
        return genericApiService.doAction(setAutoBidsDelegate, parameters);
    }
}
