package ru.yandex.direct.api.v5.entity.bids.converter.get;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.bids.BidGetItem;
import one.util.streamex.StreamEx;

@ParametersAreNonnullByDefault
public class BidGetItemWriterComposition implements BidGetItemWriter {

    private final List<BidGetItemWriter> writers;

    private BidGetItemWriterComposition(List<BidGetItemWriter> writers) {
        this.writers = writers;
    }

    /**
     * Создаёт экземпляр {@link BidGetItemWriterComposition} с {@code writers}, из которых отфильтрованы {@code null}.
     */
    static BidGetItemWriterComposition writerCompositionOf(BidGetItemWriter... writers) {
        return new BidGetItemWriterComposition(StreamEx.of(writers).nonNull().toList());
    }

    @Override
    public void write(BidGetItem bid, Long bidId) {
        writers.forEach(w -> w.write(bid, bidId));
    }
}
